<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifierGroupItem StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifierGroupItem
 * @subpackage Structs
 */
class ModifierGroupItem extends AbstractStructBase
{
    /**
     * The ItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Position;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The PriceMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PriceMethod;
    /**
     * Constructor method for ModifierGroupItem
     * @uses ModifierGroupItem::setItemId()
     * @uses ModifierGroupItem::setPosition()
     * @uses ModifierGroupItem::setPrice()
     * @uses ModifierGroupItem::setPriceMethod()
     * @param int $itemId
     * @param int $position
     * @param float $price
     * @param string $priceMethod
     */
    public function __construct($itemId = null, $position = null, $price = null, $priceMethod = null)
    {
        $this
            ->setItemId($itemId)
            ->setPosition($position)
            ->setPrice($price)
            ->setPriceMethod($priceMethod);
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \StructType\ModifierGroupItem
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !is_numeric($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get Position value
     * @return int|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \StructType\ModifierGroupItem
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !is_numeric($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\ModifierGroupItem
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceMethod value
     * @return string|null
     */
    public function getPriceMethod()
    {
        return $this->PriceMethod;
    }
    /**
     * Set PriceMethod value
     * @param string $priceMethod
     * @return \StructType\ModifierGroupItem
     */
    public function setPriceMethod($priceMethod = null)
    {
        // validation for constraint: string
        if (!is_null($priceMethod) && !is_string($priceMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceMethod)), __LINE__);
        }
        $this->PriceMethod = $priceMethod;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModifierGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
