<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemGroup StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemGroup
 * @subpackage Structs
 */
class ItemGroup extends SettingsObject
{
    /**
     * The AlternateId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternateId;
    /**
     * The Items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfItemGroupItem
     */
    public $Items;
    /**
     * Constructor method for ItemGroup
     * @uses ItemGroup::setAlternateId()
     * @uses ItemGroup::setItems()
     * @param string $alternateId
     * @param \ArrayType\ArrayOfItemGroupItem $items
     */
    public function __construct($alternateId = null, \ArrayType\ArrayOfItemGroupItem $items = null)
    {
        $this
            ->setAlternateId($alternateId)
            ->setItems($items);
    }
    /**
     * Get AlternateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternateId()
    {
        return isset($this->AlternateId) ? $this->AlternateId : null;
    }
    /**
     * Set AlternateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternateId
     * @return \StructType\ItemGroup
     */
    public function setAlternateId($alternateId = null)
    {
        // validation for constraint: string
        if (!is_null($alternateId) && !is_string($alternateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternateId)), __LINE__);
        }
        if (is_null($alternateId) || (is_array($alternateId) && empty($alternateId))) {
            unset($this->AlternateId);
        } else {
            $this->AlternateId = $alternateId;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfItemGroupItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfItemGroupItem $items
     * @return \StructType\ItemGroup
     */
    public function setItems(\ArrayType\ArrayOfItemGroupItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
