<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemCompositeComponent StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemCompositeComponent
 * @subpackage Structs
 */
class ItemCompositeComponent extends AbstractStructBase
{
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The ItemGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemGroupId;
    /**
     * The Items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfItemCompositeComponentItem
     */
    public $Items;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OverridePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OverridePrice;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Price;
    /**
     * The RollupPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RollupPrice;
    /**
     * Constructor method for ItemCompositeComponent
     * @uses ItemCompositeComponent::setId()
     * @uses ItemCompositeComponent::setItemGroupId()
     * @uses ItemCompositeComponent::setItems()
     * @uses ItemCompositeComponent::setName()
     * @uses ItemCompositeComponent::setOverridePrice()
     * @uses ItemCompositeComponent::setPrice()
     * @uses ItemCompositeComponent::setRollupPrice()
     * @param int $id
     * @param int $itemGroupId
     * @param \ArrayType\ArrayOfItemCompositeComponentItem $items
     * @param string $name
     * @param bool $overridePrice
     * @param float $price
     * @param bool $rollupPrice
     */
    public function __construct($id = null, $itemGroupId = null, \ArrayType\ArrayOfItemCompositeComponentItem $items = null, $name = null, $overridePrice = null, $price = null, $rollupPrice = null)
    {
        $this
            ->setId($id)
            ->setItemGroupId($itemGroupId)
            ->setItems($items)
            ->setName($name)
            ->setOverridePrice($overridePrice)
            ->setPrice($price)
            ->setRollupPrice($rollupPrice);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\ItemCompositeComponent
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get ItemGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemGroupId()
    {
        return isset($this->ItemGroupId) ? $this->ItemGroupId : null;
    }
    /**
     * Set ItemGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemGroupId
     * @return \StructType\ItemCompositeComponent
     */
    public function setItemGroupId($itemGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($itemGroupId) && !is_numeric($itemGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemGroupId)), __LINE__);
        }
        if (is_null($itemGroupId) || (is_array($itemGroupId) && empty($itemGroupId))) {
            unset($this->ItemGroupId);
        } else {
            $this->ItemGroupId = $itemGroupId;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfItemCompositeComponentItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfItemCompositeComponentItem $items
     * @return \StructType\ItemCompositeComponent
     */
    public function setItems(\ArrayType\ArrayOfItemCompositeComponentItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\ItemCompositeComponent
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OverridePrice value
     * @return bool|null
     */
    public function getOverridePrice()
    {
        return $this->OverridePrice;
    }
    /**
     * Set OverridePrice value
     * @param bool $overridePrice
     * @return \StructType\ItemCompositeComponent
     */
    public function setOverridePrice($overridePrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($overridePrice) && !is_bool($overridePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($overridePrice)), __LINE__);
        }
        $this->OverridePrice = $overridePrice;
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price
     * @return \StructType\ItemCompositeComponent
     */
    public function setPrice($price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get RollupPrice value
     * @return bool|null
     */
    public function getRollupPrice()
    {
        return $this->RollupPrice;
    }
    /**
     * Set RollupPrice value
     * @param bool $rollupPrice
     * @return \StructType\ItemCompositeComponent
     */
    public function setRollupPrice($rollupPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($rollupPrice) && !is_bool($rollupPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($rollupPrice)), __LINE__);
        }
        $this->RollupPrice = $rollupPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemCompositeComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
