<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployeeJob StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:EmployeeJob
 * @subpackage Structs
 */
class EmployeeJob extends AbstractStructBase
{
    /**
     * The JobId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $JobId;
    /**
     * The PayRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PayRate;
    /**
     * The SecurityLevelId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SecurityLevelId;
    /**
     * Constructor method for EmployeeJob
     * @uses EmployeeJob::setJobId()
     * @uses EmployeeJob::setPayRate()
     * @uses EmployeeJob::setSecurityLevelId()
     * @param int $jobId
     * @param float $payRate
     * @param int $securityLevelId
     */
    public function __construct($jobId = null, $payRate = null, $securityLevelId = null)
    {
        $this
            ->setJobId($jobId)
            ->setPayRate($payRate)
            ->setSecurityLevelId($securityLevelId);
    }
    /**
     * Get JobId value
     * @return int|null
     */
    public function getJobId()
    {
        return $this->JobId;
    }
    /**
     * Set JobId value
     * @param int $jobId
     * @return \StructType\EmployeeJob
     */
    public function setJobId($jobId = null)
    {
        // validation for constraint: int
        if (!is_null($jobId) && !is_numeric($jobId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($jobId)), __LINE__);
        }
        $this->JobId = $jobId;
        return $this;
    }
    /**
     * Get PayRate value
     * @return float|null
     */
    public function getPayRate()
    {
        return $this->PayRate;
    }
    /**
     * Set PayRate value
     * @param float $payRate
     * @return \StructType\EmployeeJob
     */
    public function setPayRate($payRate = null)
    {
        $this->PayRate = $payRate;
        return $this;
    }
    /**
     * Get SecurityLevelId value
     * @return int|null
     */
    public function getSecurityLevelId()
    {
        return $this->SecurityLevelId;
    }
    /**
     * Set SecurityLevelId value
     * @param int $securityLevelId
     * @return \StructType\EmployeeJob
     */
    public function setSecurityLevelId($securityLevelId = null)
    {
        // validation for constraint: int
        if (!is_null($securityLevelId) && !is_numeric($securityLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($securityLevelId)), __LINE__);
        }
        $this->SecurityLevelId = $securityLevelId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EmployeeJob
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
