<?php

namespace EnumType;

/**
 * This class stands for TenderType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TenderType
 * @subpackage Enumerations
 */
class TenderType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Cash'
     * @return string 'Cash'
     */
    const VALUE_CASH = 'Cash';
    /**
     * Constant for value 'CreditCard'
     * @return string 'CreditCard'
     */
    const VALUE_CREDIT_CARD = 'CreditCard';
    /**
     * Constant for value 'GiftCard'
     * @return string 'GiftCard'
     */
    const VALUE_GIFT_CARD = 'GiftCard';
    /**
     * Constant for value 'GiftCertificate'
     * @return string 'GiftCertificate'
     */
    const VALUE_GIFT_CERTIFICATE = 'GiftCertificate';
    /**
     * Constant for value 'Check'
     * @return string 'Check'
     */
    const VALUE_CHECK = 'Check';
    /**
     * Constant for value 'HouseAccount'
     * @return string 'HouseAccount'
     */
    const VALUE_HOUSE_ACCOUNT = 'HouseAccount';
    /**
     * Constant for value 'External'
     * @return string 'External'
     */
    const VALUE_EXTERNAL = 'External';
    /**
     * Constant for value 'Debit'
     * @return string 'Debit'
     */
    const VALUE_DEBIT = 'Debit';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_CASH
     * @uses self::VALUE_CREDIT_CARD
     * @uses self::VALUE_GIFT_CARD
     * @uses self::VALUE_GIFT_CERTIFICATE
     * @uses self::VALUE_CHECK
     * @uses self::VALUE_HOUSE_ACCOUNT
     * @uses self::VALUE_EXTERNAL
     * @uses self::VALUE_DEBIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_CASH,
            self::VALUE_CREDIT_CARD,
            self::VALUE_GIFT_CARD,
            self::VALUE_GIFT_CERTIFICATE,
            self::VALUE_CHECK,
            self::VALUE_HOUSE_ACCOUNT,
            self::VALUE_EXTERNAL,
            self::VALUE_DEBIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
