<?php

namespace EnumType;

/**
 * This class stands for PettyAccountType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PettyAccountType
 * @subpackage Enumerations
 */
class PettyAccountType
{
    /**
     * Constant for value 'CashIn'
     * @return string 'CashIn'
     */
    const VALUE_CASH_IN = 'CashIn';
    /**
     * Constant for value 'CashOut'
     * @return string 'CashOut'
     */
    const VALUE_CASH_OUT = 'CashOut';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CASH_IN
     * @uses self::VALUE_CASH_OUT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CASH_IN,
            self::VALUE_CASH_OUT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
