<?php

namespace EnumType;

/**
 * This class stands for ModCodeIngredientType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ModCodeIngredientType
 * @subpackage Enumerations
 */
class ModCodeIngredientType
{
    /**
     * Constant for value 'Ingredients'
     * @return string 'Ingredients'
     */
    const VALUE_INGREDIENTS = 'Ingredients';
    /**
     * Constant for value 'NonIngredients'
     * @return string 'NonIngredients'
     */
    const VALUE_NON_INGREDIENTS = 'NonIngredients';
    /**
     * Constant for value 'Both'
     * @return string 'Both'
     */
    const VALUE_BOTH = 'Both';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INGREDIENTS
     * @uses self::VALUE_NON_INGREDIENTS
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INGREDIENTS,
            self::VALUE_NON_INGREDIENTS,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
