<?php

namespace EnumType;

/**
 * This class stands for DiscountType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DiscountType
 * @subpackage Enumerations
 */
class DiscountType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Comp'
     * @return string 'Comp'
     */
    const VALUE_COMP = 'Comp';
    /**
     * Constant for value 'NewPrice'
     * @return string 'NewPrice'
     */
    const VALUE_NEW_PRICE = 'NewPrice';
    /**
     * Constant for value 'Max'
     * @return string 'Max'
     */
    const VALUE_MAX = 'Max';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_COMP
     * @uses self::VALUE_NEW_PRICE
     * @uses self::VALUE_MAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_COMP,
            self::VALUE_NEW_PRICE,
            self::VALUE_MAX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
