<?php

namespace EnumType;

/**
 * This class stands for AccessErrorCode EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AccessErrorCode
 * @subpackage Enumerations
 */
class AccessErrorCode
{
    /**
     * Constant for value 'InvalidToken'
     * @return string 'InvalidToken'
     */
    const VALUE_INVALID_TOKEN = 'InvalidToken';
    /**
     * Constant for value 'AccessDenied'
     * @return string 'AccessDenied'
     */
    const VALUE_ACCESS_DENIED = 'AccessDenied';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INVALID_TOKEN
     * @uses self::VALUE_ACCESS_DENIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INVALID_TOKEN,
            self::VALUE_ACCESS_DENIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
