<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPettyAccount ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPettyAccount
 * @subpackage Arrays
 */
class ArrayOfPettyAccount extends AbstractStructArrayBase
{
    /**
     * The PettyAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PettyAccount[]
     */
    public $PettyAccount;
    /**
     * Constructor method for ArrayOfPettyAccount
     * @uses ArrayOfPettyAccount::setPettyAccount()
     * @param \StructType\PettyAccount[] $pettyAccount
     */
    public function __construct(array $pettyAccount = array())
    {
        $this
            ->setPettyAccount($pettyAccount);
    }
    /**
     * Get PettyAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PettyAccount[]|null
     */
    public function getPettyAccount()
    {
        return isset($this->PettyAccount) ? $this->PettyAccount : null;
    }
    /**
     * Set PettyAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PettyAccount[] $pettyAccount
     * @return \ArrayType\ArrayOfPettyAccount
     */
    public function setPettyAccount(array $pettyAccount = array())
    {
        foreach ($pettyAccount as $arrayOfPettyAccountPettyAccountItem) {
            // validation for constraint: itemType
            if (!$arrayOfPettyAccountPettyAccountItem instanceof \StructType\PettyAccount) {
                throw new \InvalidArgumentException(sprintf('The PettyAccount property can only contain items of \StructType\PettyAccount, "%s" given', is_object($arrayOfPettyAccountPettyAccountItem) ? get_class($arrayOfPettyAccountPettyAccountItem) : gettype($arrayOfPettyAccountPettyAccountItem)), __LINE__);
            }
        }
        if (is_null($pettyAccount) || (is_array($pettyAccount) && empty($pettyAccount))) {
            unset($this->PettyAccount);
        } else {
            $this->PettyAccount = $pettyAccount;
        }
        return $this;
    }
    /**
     * Add item to PettyAccount value
     * @throws \InvalidArgumentException
     * @param \StructType\PettyAccount $item
     * @return \ArrayType\ArrayOfPettyAccount
     */
    public function addToPettyAccount(\StructType\PettyAccount $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PettyAccount) {
            throw new \InvalidArgumentException(sprintf('The PettyAccount property can only contain items of \StructType\PettyAccount, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PettyAccount[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PettyAccount|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PettyAccount|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PettyAccount|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PettyAccount|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PettyAccount|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PettyAccount
     */
    public function getAttributeName()
    {
        return 'PettyAccount';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPettyAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
