<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemGroup ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfItemGroup
 * @subpackage Arrays
 */
class ArrayOfItemGroup extends AbstractStructArrayBase
{
    /**
     * The ItemGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemGroup[]
     */
    public $ItemGroup;
    /**
     * Constructor method for ArrayOfItemGroup
     * @uses ArrayOfItemGroup::setItemGroup()
     * @param \StructType\ItemGroup[] $itemGroup
     */
    public function __construct(array $itemGroup = array())
    {
        $this
            ->setItemGroup($itemGroup);
    }
    /**
     * Get ItemGroup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemGroup[]|null
     */
    public function getItemGroup()
    {
        return isset($this->ItemGroup) ? $this->ItemGroup : null;
    }
    /**
     * Set ItemGroup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemGroup[] $itemGroup
     * @return \ArrayType\ArrayOfItemGroup
     */
    public function setItemGroup(array $itemGroup = array())
    {
        foreach ($itemGroup as $arrayOfItemGroupItemGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemGroupItemGroupItem instanceof \StructType\ItemGroup) {
                throw new \InvalidArgumentException(sprintf('The ItemGroup property can only contain items of \StructType\ItemGroup, "%s" given', is_object($arrayOfItemGroupItemGroupItem) ? get_class($arrayOfItemGroupItemGroupItem) : gettype($arrayOfItemGroupItemGroupItem)), __LINE__);
            }
        }
        if (is_null($itemGroup) || (is_array($itemGroup) && empty($itemGroup))) {
            unset($this->ItemGroup);
        } else {
            $this->ItemGroup = $itemGroup;
        }
        return $this;
    }
    /**
     * Add item to ItemGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemGroup $item
     * @return \ArrayType\ArrayOfItemGroup
     */
    public function addToItemGroup(\StructType\ItemGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemGroup) {
            throw new \InvalidArgumentException(sprintf('The ItemGroup property can only contain items of \StructType\ItemGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemGroup|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemGroup|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemGroup|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemGroup|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemGroup|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemGroup
     */
    public function getAttributeName()
    {
        return 'ItemGroup';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItemGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
