<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDayPart ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDayPart
 * @subpackage Arrays
 */
class ArrayOfDayPart extends AbstractStructArrayBase
{
    /**
     * The DayPart
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DayPart[]
     */
    public $DayPart;
    /**
     * Constructor method for ArrayOfDayPart
     * @uses ArrayOfDayPart::setDayPart()
     * @param \StructType\DayPart[] $dayPart
     */
    public function __construct(array $dayPart = array())
    {
        $this
            ->setDayPart($dayPart);
    }
    /**
     * Get DayPart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DayPart[]|null
     */
    public function getDayPart()
    {
        return isset($this->DayPart) ? $this->DayPart : null;
    }
    /**
     * Set DayPart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DayPart[] $dayPart
     * @return \ArrayType\ArrayOfDayPart
     */
    public function setDayPart(array $dayPart = array())
    {
        foreach ($dayPart as $arrayOfDayPartDayPartItem) {
            // validation for constraint: itemType
            if (!$arrayOfDayPartDayPartItem instanceof \StructType\DayPart) {
                throw new \InvalidArgumentException(sprintf('The DayPart property can only contain items of \StructType\DayPart, "%s" given', is_object($arrayOfDayPartDayPartItem) ? get_class($arrayOfDayPartDayPartItem) : gettype($arrayOfDayPartDayPartItem)), __LINE__);
            }
        }
        if (is_null($dayPart) || (is_array($dayPart) && empty($dayPart))) {
            unset($this->DayPart);
        } else {
            $this->DayPart = $dayPart;
        }
        return $this;
    }
    /**
     * Add item to DayPart value
     * @throws \InvalidArgumentException
     * @param \StructType\DayPart $item
     * @return \ArrayType\ArrayOfDayPart
     */
    public function addToDayPart(\StructType\DayPart $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DayPart) {
            throw new \InvalidArgumentException(sprintf('The DayPart property can only contain items of \StructType\DayPart, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->DayPart[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DayPart|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DayPart|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DayPart|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DayPart|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DayPart|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DayPart
     */
    public function getAttributeName()
    {
        return 'DayPart';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfDayPart
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
