<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tender StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Tender
 * @subpackage Structs
 */
class Tender extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The AllowChange
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowChange;
    /**
     * The AllowTips
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowTips;
    /**
     * The CardType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CardType;
    /**
     * The DefaultAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DefaultAmount;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The MaxTipPercent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MaxTipPercent;
    /**
     * The MaximumAccountDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaximumAccountDigits;
    /**
     * The MinimumAccountDigits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MinimumAccountDigits;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OpenDrawer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OpenDrawer;
    /**
     * The ReconciliationMethod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReconciliationMethod;
    /**
     * The RequiresAuthorization
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RequiresAuthorization;
    /**
     * The SignatureCapture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SignatureCapture;
    /**
     * The TenderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TenderType;
    /**
     * The VarianceAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VarianceAmount;
    /**
     * Constructor method for Tender
     * @uses Tender::setActive()
     * @uses Tender::setAllowChange()
     * @uses Tender::setAllowTips()
     * @uses Tender::setCardType()
     * @uses Tender::setDefaultAmount()
     * @uses Tender::setId()
     * @uses Tender::setMaxTipPercent()
     * @uses Tender::setMaximumAccountDigits()
     * @uses Tender::setMinimumAccountDigits()
     * @uses Tender::setName()
     * @uses Tender::setOpenDrawer()
     * @uses Tender::setReconciliationMethod()
     * @uses Tender::setRequiresAuthorization()
     * @uses Tender::setSignatureCapture()
     * @uses Tender::setTenderType()
     * @uses Tender::setVarianceAmount()
     * @param bool $active
     * @param bool $allowChange
     * @param bool $allowTips
     * @param string $cardType
     * @param float $defaultAmount
     * @param int $id
     * @param float $maxTipPercent
     * @param string $maximumAccountDigits
     * @param string $minimumAccountDigits
     * @param string $name
     * @param bool $openDrawer
     * @param string $reconciliationMethod
     * @param bool $requiresAuthorization
     * @param bool $signatureCapture
     * @param string $tenderType
     * @param float $varianceAmount
     */
    public function __construct($active = null, $allowChange = null, $allowTips = null, $cardType = null, $defaultAmount = null, $id = null, $maxTipPercent = null, $maximumAccountDigits = null, $minimumAccountDigits = null, $name = null, $openDrawer = null, $reconciliationMethod = null, $requiresAuthorization = null, $signatureCapture = null, $tenderType = null, $varianceAmount = null)
    {
        $this
            ->setActive($active)
            ->setAllowChange($allowChange)
            ->setAllowTips($allowTips)
            ->setCardType($cardType)
            ->setDefaultAmount($defaultAmount)
            ->setId($id)
            ->setMaxTipPercent($maxTipPercent)
            ->setMaximumAccountDigits($maximumAccountDigits)
            ->setMinimumAccountDigits($minimumAccountDigits)
            ->setName($name)
            ->setOpenDrawer($openDrawer)
            ->setReconciliationMethod($reconciliationMethod)
            ->setRequiresAuthorization($requiresAuthorization)
            ->setSignatureCapture($signatureCapture)
            ->setTenderType($tenderType)
            ->setVarianceAmount($varianceAmount);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Tender
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AllowChange value
     * @return bool|null
     */
    public function getAllowChange()
    {
        return $this->AllowChange;
    }
    /**
     * Set AllowChange value
     * @param bool $allowChange
     * @return \StructType\Tender
     */
    public function setAllowChange($allowChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChange) && !is_bool($allowChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowChange)), __LINE__);
        }
        $this->AllowChange = $allowChange;
        return $this;
    }
    /**
     * Get AllowTips value
     * @return bool|null
     */
    public function getAllowTips()
    {
        return $this->AllowTips;
    }
    /**
     * Set AllowTips value
     * @param bool $allowTips
     * @return \StructType\Tender
     */
    public function setAllowTips($allowTips = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowTips) && !is_bool($allowTips)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowTips)), __LINE__);
        }
        $this->AllowTips = $allowTips;
        return $this;
    }
    /**
     * Get CardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->CardType;
    }
    /**
     * Set CardType value
     * @uses \EnumType\CardType::valueIsValid()
     * @uses \EnumType\CardType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardType
     * @return \StructType\Tender
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CardType::valueIsValid($cardType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cardType, implode(', ', \EnumType\CardType::getValidValues())), __LINE__);
        }
        $this->CardType = $cardType;
        return $this;
    }
    /**
     * Get DefaultAmount value
     * @return float|null
     */
    public function getDefaultAmount()
    {
        return $this->DefaultAmount;
    }
    /**
     * Set DefaultAmount value
     * @param float $defaultAmount
     * @return \StructType\Tender
     */
    public function setDefaultAmount($defaultAmount = null)
    {
        $this->DefaultAmount = $defaultAmount;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Tender
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get MaxTipPercent value
     * @return float|null
     */
    public function getMaxTipPercent()
    {
        return $this->MaxTipPercent;
    }
    /**
     * Set MaxTipPercent value
     * @param float $maxTipPercent
     * @return \StructType\Tender
     */
    public function setMaxTipPercent($maxTipPercent = null)
    {
        $this->MaxTipPercent = $maxTipPercent;
        return $this;
    }
    /**
     * Get MaximumAccountDigits value
     * @return string|null
     */
    public function getMaximumAccountDigits()
    {
        return $this->MaximumAccountDigits;
    }
    /**
     * Set MaximumAccountDigits value
     * @param string $maximumAccountDigits
     * @return \StructType\Tender
     */
    public function setMaximumAccountDigits($maximumAccountDigits = null)
    {
        // validation for constraint: string
        if (!is_null($maximumAccountDigits) && !is_string($maximumAccountDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximumAccountDigits)), __LINE__);
        }
        $this->MaximumAccountDigits = $maximumAccountDigits;
        return $this;
    }
    /**
     * Get MinimumAccountDigits value
     * @return string|null
     */
    public function getMinimumAccountDigits()
    {
        return $this->MinimumAccountDigits;
    }
    /**
     * Set MinimumAccountDigits value
     * @param string $minimumAccountDigits
     * @return \StructType\Tender
     */
    public function setMinimumAccountDigits($minimumAccountDigits = null)
    {
        // validation for constraint: string
        if (!is_null($minimumAccountDigits) && !is_string($minimumAccountDigits)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimumAccountDigits)), __LINE__);
        }
        $this->MinimumAccountDigits = $minimumAccountDigits;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Tender
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OpenDrawer value
     * @return bool|null
     */
    public function getOpenDrawer()
    {
        return $this->OpenDrawer;
    }
    /**
     * Set OpenDrawer value
     * @param bool $openDrawer
     * @return \StructType\Tender
     */
    public function setOpenDrawer($openDrawer = null)
    {
        // validation for constraint: boolean
        if (!is_null($openDrawer) && !is_bool($openDrawer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($openDrawer)), __LINE__);
        }
        $this->OpenDrawer = $openDrawer;
        return $this;
    }
    /**
     * Get ReconciliationMethod value
     * @return string|null
     */
    public function getReconciliationMethod()
    {
        return $this->ReconciliationMethod;
    }
    /**
     * Set ReconciliationMethod value
     * @uses \EnumType\ReconciliationMethod::valueIsValid()
     * @uses \EnumType\ReconciliationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reconciliationMethod
     * @return \StructType\Tender
     */
    public function setReconciliationMethod($reconciliationMethod = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReconciliationMethod::valueIsValid($reconciliationMethod)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $reconciliationMethod, implode(', ', \EnumType\ReconciliationMethod::getValidValues())), __LINE__);
        }
        $this->ReconciliationMethod = $reconciliationMethod;
        return $this;
    }
    /**
     * Get RequiresAuthorization value
     * @return bool|null
     */
    public function getRequiresAuthorization()
    {
        return $this->RequiresAuthorization;
    }
    /**
     * Set RequiresAuthorization value
     * @param bool $requiresAuthorization
     * @return \StructType\Tender
     */
    public function setRequiresAuthorization($requiresAuthorization = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresAuthorization) && !is_bool($requiresAuthorization)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($requiresAuthorization)), __LINE__);
        }
        $this->RequiresAuthorization = $requiresAuthorization;
        return $this;
    }
    /**
     * Get SignatureCapture value
     * @return bool|null
     */
    public function getSignatureCapture()
    {
        return $this->SignatureCapture;
    }
    /**
     * Set SignatureCapture value
     * @param bool $signatureCapture
     * @return \StructType\Tender
     */
    public function setSignatureCapture($signatureCapture = null)
    {
        // validation for constraint: boolean
        if (!is_null($signatureCapture) && !is_bool($signatureCapture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($signatureCapture)), __LINE__);
        }
        $this->SignatureCapture = $signatureCapture;
        return $this;
    }
    /**
     * Get TenderType value
     * @return string|null
     */
    public function getTenderType()
    {
        return $this->TenderType;
    }
    /**
     * Set TenderType value
     * @uses \EnumType\TenderType::valueIsValid()
     * @uses \EnumType\TenderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tenderType
     * @return \StructType\Tender
     */
    public function setTenderType($tenderType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TenderType::valueIsValid($tenderType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tenderType, implode(', ', \EnumType\TenderType::getValidValues())), __LINE__);
        }
        $this->TenderType = $tenderType;
        return $this;
    }
    /**
     * Get VarianceAmount value
     * @return float|null
     */
    public function getVarianceAmount()
    {
        return $this->VarianceAmount;
    }
    /**
     * Set VarianceAmount value
     * @param float $varianceAmount
     * @return \StructType\Tender
     */
    public function setVarianceAmount($varianceAmount = null)
    {
        $this->VarianceAmount = $varianceAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tender
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
