<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Surcharge StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Surcharge
 * @subpackage Structs
 */
class Surcharge extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The AutomaticallyApply
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AutomaticallyApply;
    /**
     * The Days
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Days;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndTime;
    /**
     * The EnforceDateRanges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EnforceDateRanges;
    /**
     * The EnforceDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EnforceDays;
    /**
     * The EnforcePartySize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EnforcePartySize;
    /**
     * The EnforceTimeRanges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EnforceTimeRanges;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The LimitDestinations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LimitDestinations;
    /**
     * The LimitSections
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $LimitSections;
    /**
     * The MaximumPartySize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaximumPartySize;
    /**
     * The Method
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Method;
    /**
     * The MinimumPartySize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MinimumPartySize;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Prompt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Prompt;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartTime;
    /**
     * The TaxIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $TaxIds;
    /**
     * The TerminalTypes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TerminalTypes;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Type;
    /**
     * The ValidDestinationIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ValidDestinationIds;
    /**
     * The ValidSectionIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ValidSectionIds;
    /**
     * Constructor method for Surcharge
     * @uses Surcharge::setAmount()
     * @uses Surcharge::setAutomaticallyApply()
     * @uses Surcharge::setDays()
     * @uses Surcharge::setEndDate()
     * @uses Surcharge::setEndTime()
     * @uses Surcharge::setEnforceDateRanges()
     * @uses Surcharge::setEnforceDays()
     * @uses Surcharge::setEnforcePartySize()
     * @uses Surcharge::setEnforceTimeRanges()
     * @uses Surcharge::setId()
     * @uses Surcharge::setLimitDestinations()
     * @uses Surcharge::setLimitSections()
     * @uses Surcharge::setMaximumPartySize()
     * @uses Surcharge::setMethod()
     * @uses Surcharge::setMinimumPartySize()
     * @uses Surcharge::setName()
     * @uses Surcharge::setPrompt()
     * @uses Surcharge::setStartDate()
     * @uses Surcharge::setStartTime()
     * @uses Surcharge::setTaxIds()
     * @uses Surcharge::setTerminalTypes()
     * @uses Surcharge::setType()
     * @uses Surcharge::setValidDestinationIds()
     * @uses Surcharge::setValidSectionIds()
     * @param float $amount
     * @param bool $automaticallyApply
     * @param int $days
     * @param string $endDate
     * @param string $endTime
     * @param bool $enforceDateRanges
     * @param bool $enforceDays
     * @param bool $enforcePartySize
     * @param bool $enforceTimeRanges
     * @param int $id
     * @param bool $limitDestinations
     * @param bool $limitSections
     * @param int $maximumPartySize
     * @param int $method
     * @param int $minimumPartySize
     * @param string $name
     * @param bool $prompt
     * @param string $startDate
     * @param string $startTime
     * @param \ArrayType\ArrayOfint $taxIds
     * @param int $terminalTypes
     * @param int $type
     * @param \ArrayType\ArrayOfint $validDestinationIds
     * @param \ArrayType\ArrayOfint $validSectionIds
     */
    public function __construct($amount = null, $automaticallyApply = null, $days = null, $endDate = null, $endTime = null, $enforceDateRanges = null, $enforceDays = null, $enforcePartySize = null, $enforceTimeRanges = null, $id = null, $limitDestinations = null, $limitSections = null, $maximumPartySize = null, $method = null, $minimumPartySize = null, $name = null, $prompt = null, $startDate = null, $startTime = null, \ArrayType\ArrayOfint $taxIds = null, $terminalTypes = null, $type = null, \ArrayType\ArrayOfint $validDestinationIds = null, \ArrayType\ArrayOfint $validSectionIds = null)
    {
        $this
            ->setAmount($amount)
            ->setAutomaticallyApply($automaticallyApply)
            ->setDays($days)
            ->setEndDate($endDate)
            ->setEndTime($endTime)
            ->setEnforceDateRanges($enforceDateRanges)
            ->setEnforceDays($enforceDays)
            ->setEnforcePartySize($enforcePartySize)
            ->setEnforceTimeRanges($enforceTimeRanges)
            ->setId($id)
            ->setLimitDestinations($limitDestinations)
            ->setLimitSections($limitSections)
            ->setMaximumPartySize($maximumPartySize)
            ->setMethod($method)
            ->setMinimumPartySize($minimumPartySize)
            ->setName($name)
            ->setPrompt($prompt)
            ->setStartDate($startDate)
            ->setStartTime($startTime)
            ->setTaxIds($taxIds)
            ->setTerminalTypes($terminalTypes)
            ->setType($type)
            ->setValidDestinationIds($validDestinationIds)
            ->setValidSectionIds($validSectionIds);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Surcharge
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get AutomaticallyApply value
     * @return bool|null
     */
    public function getAutomaticallyApply()
    {
        return $this->AutomaticallyApply;
    }
    /**
     * Set AutomaticallyApply value
     * @param bool $automaticallyApply
     * @return \StructType\Surcharge
     */
    public function setAutomaticallyApply($automaticallyApply = null)
    {
        // validation for constraint: boolean
        if (!is_null($automaticallyApply) && !is_bool($automaticallyApply)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($automaticallyApply)), __LINE__);
        }
        $this->AutomaticallyApply = $automaticallyApply;
        return $this;
    }
    /**
     * Get Days value
     * @return int|null
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \StructType\Surcharge
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !is_numeric($days)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Surcharge
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\Surcharge
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get EnforceDateRanges value
     * @return bool|null
     */
    public function getEnforceDateRanges()
    {
        return $this->EnforceDateRanges;
    }
    /**
     * Set EnforceDateRanges value
     * @param bool $enforceDateRanges
     * @return \StructType\Surcharge
     */
    public function setEnforceDateRanges($enforceDateRanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceDateRanges) && !is_bool($enforceDateRanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enforceDateRanges)), __LINE__);
        }
        $this->EnforceDateRanges = $enforceDateRanges;
        return $this;
    }
    /**
     * Get EnforceDays value
     * @return bool|null
     */
    public function getEnforceDays()
    {
        return $this->EnforceDays;
    }
    /**
     * Set EnforceDays value
     * @param bool $enforceDays
     * @return \StructType\Surcharge
     */
    public function setEnforceDays($enforceDays = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceDays) && !is_bool($enforceDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enforceDays)), __LINE__);
        }
        $this->EnforceDays = $enforceDays;
        return $this;
    }
    /**
     * Get EnforcePartySize value
     * @return bool|null
     */
    public function getEnforcePartySize()
    {
        return $this->EnforcePartySize;
    }
    /**
     * Set EnforcePartySize value
     * @param bool $enforcePartySize
     * @return \StructType\Surcharge
     */
    public function setEnforcePartySize($enforcePartySize = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforcePartySize) && !is_bool($enforcePartySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enforcePartySize)), __LINE__);
        }
        $this->EnforcePartySize = $enforcePartySize;
        return $this;
    }
    /**
     * Get EnforceTimeRanges value
     * @return bool|null
     */
    public function getEnforceTimeRanges()
    {
        return $this->EnforceTimeRanges;
    }
    /**
     * Set EnforceTimeRanges value
     * @param bool $enforceTimeRanges
     * @return \StructType\Surcharge
     */
    public function setEnforceTimeRanges($enforceTimeRanges = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceTimeRanges) && !is_bool($enforceTimeRanges)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enforceTimeRanges)), __LINE__);
        }
        $this->EnforceTimeRanges = $enforceTimeRanges;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Surcharge
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get LimitDestinations value
     * @return bool|null
     */
    public function getLimitDestinations()
    {
        return $this->LimitDestinations;
    }
    /**
     * Set LimitDestinations value
     * @param bool $limitDestinations
     * @return \StructType\Surcharge
     */
    public function setLimitDestinations($limitDestinations = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitDestinations) && !is_bool($limitDestinations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($limitDestinations)), __LINE__);
        }
        $this->LimitDestinations = $limitDestinations;
        return $this;
    }
    /**
     * Get LimitSections value
     * @return bool|null
     */
    public function getLimitSections()
    {
        return $this->LimitSections;
    }
    /**
     * Set LimitSections value
     * @param bool $limitSections
     * @return \StructType\Surcharge
     */
    public function setLimitSections($limitSections = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitSections) && !is_bool($limitSections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($limitSections)), __LINE__);
        }
        $this->LimitSections = $limitSections;
        return $this;
    }
    /**
     * Get MaximumPartySize value
     * @return int|null
     */
    public function getMaximumPartySize()
    {
        return $this->MaximumPartySize;
    }
    /**
     * Set MaximumPartySize value
     * @param int $maximumPartySize
     * @return \StructType\Surcharge
     */
    public function setMaximumPartySize($maximumPartySize = null)
    {
        // validation for constraint: int
        if (!is_null($maximumPartySize) && !is_numeric($maximumPartySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumPartySize)), __LINE__);
        }
        $this->MaximumPartySize = $maximumPartySize;
        return $this;
    }
    /**
     * Get Method value
     * @return int|null
     */
    public function getMethod()
    {
        return $this->Method;
    }
    /**
     * Set Method value
     * @param int $method
     * @return \StructType\Surcharge
     */
    public function setMethod($method = null)
    {
        // validation for constraint: int
        if (!is_null($method) && !is_numeric($method)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($method)), __LINE__);
        }
        $this->Method = $method;
        return $this;
    }
    /**
     * Get MinimumPartySize value
     * @return int|null
     */
    public function getMinimumPartySize()
    {
        return $this->MinimumPartySize;
    }
    /**
     * Set MinimumPartySize value
     * @param int $minimumPartySize
     * @return \StructType\Surcharge
     */
    public function setMinimumPartySize($minimumPartySize = null)
    {
        // validation for constraint: int
        if (!is_null($minimumPartySize) && !is_numeric($minimumPartySize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimumPartySize)), __LINE__);
        }
        $this->MinimumPartySize = $minimumPartySize;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Surcharge
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Prompt value
     * @return bool|null
     */
    public function getPrompt()
    {
        return $this->Prompt;
    }
    /**
     * Set Prompt value
     * @param bool $prompt
     * @return \StructType\Surcharge
     */
    public function setPrompt($prompt = null)
    {
        // validation for constraint: boolean
        if (!is_null($prompt) && !is_bool($prompt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($prompt)), __LINE__);
        }
        $this->Prompt = $prompt;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Surcharge
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\Surcharge
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get TaxIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getTaxIds()
    {
        return isset($this->TaxIds) ? $this->TaxIds : null;
    }
    /**
     * Set TaxIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $taxIds
     * @return \StructType\Surcharge
     */
    public function setTaxIds(\ArrayType\ArrayOfint $taxIds = null)
    {
        if (is_null($taxIds) || (is_array($taxIds) && empty($taxIds))) {
            unset($this->TaxIds);
        } else {
            $this->TaxIds = $taxIds;
        }
        return $this;
    }
    /**
     * Get TerminalTypes value
     * @return int|null
     */
    public function getTerminalTypes()
    {
        return $this->TerminalTypes;
    }
    /**
     * Set TerminalTypes value
     * @param int $terminalTypes
     * @return \StructType\Surcharge
     */
    public function setTerminalTypes($terminalTypes = null)
    {
        // validation for constraint: int
        if (!is_null($terminalTypes) && !is_numeric($terminalTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($terminalTypes)), __LINE__);
        }
        $this->TerminalTypes = $terminalTypes;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\Surcharge
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ValidDestinationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getValidDestinationIds()
    {
        return isset($this->ValidDestinationIds) ? $this->ValidDestinationIds : null;
    }
    /**
     * Set ValidDestinationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $validDestinationIds
     * @return \StructType\Surcharge
     */
    public function setValidDestinationIds(\ArrayType\ArrayOfint $validDestinationIds = null)
    {
        if (is_null($validDestinationIds) || (is_array($validDestinationIds) && empty($validDestinationIds))) {
            unset($this->ValidDestinationIds);
        } else {
            $this->ValidDestinationIds = $validDestinationIds;
        }
        return $this;
    }
    /**
     * Get ValidSectionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getValidSectionIds()
    {
        return isset($this->ValidSectionIds) ? $this->ValidSectionIds : null;
    }
    /**
     * Set ValidSectionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $validSectionIds
     * @return \StructType\Surcharge
     */
    public function setValidSectionIds(\ArrayType\ArrayOfint $validSectionIds = null)
    {
        if (is_null($validSectionIds) || (is_array($validSectionIds) && empty($validSectionIds))) {
            unset($this->ValidSectionIds);
        } else {
            $this->ValidSectionIds = $validSectionIds;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Surcharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
