<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Options StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Options
 * @subpackage Structs
 */
class Options extends AbstractStructBase
{
    /**
     * The Accounting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountingOptions
     */
    public $Accounting;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LocationOptions
     */
    public $Location;
    /**
     * Constructor method for Options
     * @uses Options::setAccounting()
     * @uses Options::setLocation()
     * @param \StructType\AccountingOptions $accounting
     * @param \StructType\LocationOptions $location
     */
    public function __construct(\StructType\AccountingOptions $accounting = null, \StructType\LocationOptions $location = null)
    {
        $this
            ->setAccounting($accounting)
            ->setLocation($location);
    }
    /**
     * Get Accounting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountingOptions|null
     */
    public function getAccounting()
    {
        return isset($this->Accounting) ? $this->Accounting : null;
    }
    /**
     * Set Accounting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AccountingOptions $accounting
     * @return \StructType\Options
     */
    public function setAccounting(\StructType\AccountingOptions $accounting = null)
    {
        if (is_null($accounting) || (is_array($accounting) && empty($accounting))) {
            unset($this->Accounting);
        } else {
            $this->Accounting = $accounting;
        }
        return $this;
    }
    /**
     * Get Location value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LocationOptions|null
     */
    public function getLocation()
    {
        return isset($this->Location) ? $this->Location : null;
    }
    /**
     * Set Location value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\LocationOptions $location
     * @return \StructType\Options
     */
    public function setLocation(\StructType\LocationOptions $location = null)
    {
        if (is_null($location) || (is_array($location) && empty($location))) {
            unset($this->Location);
        } else {
            $this->Location = $location;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Options
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
