<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifierGroup StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifierGroup
 * @subpackage Structs
 */
class ModifierGroup extends SettingsObject
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The FlowRequired
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $FlowRequired;
    /**
     * The Free
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Free;
    /**
     * The Items
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfModifierGroupItem
     */
    public $Items;
    /**
     * The Maximum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Maximum;
    /**
     * The Minimum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Minimum;
    /**
     * The PanelId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PanelId;
    /**
     * Constructor method for ModifierGroup
     * @uses ModifierGroup::setDescription()
     * @uses ModifierGroup::setDisplayName()
     * @uses ModifierGroup::setFlowRequired()
     * @uses ModifierGroup::setFree()
     * @uses ModifierGroup::setItems()
     * @uses ModifierGroup::setMaximum()
     * @uses ModifierGroup::setMinimum()
     * @uses ModifierGroup::setPanelId()
     * @param string $description
     * @param string $displayName
     * @param bool $flowRequired
     * @param string $free
     * @param \ArrayType\ArrayOfModifierGroupItem $items
     * @param string $maximum
     * @param string $minimum
     * @param int $panelId
     */
    public function __construct($description = null, $displayName = null, $flowRequired = null, $free = null, \ArrayType\ArrayOfModifierGroupItem $items = null, $maximum = null, $minimum = null, $panelId = null)
    {
        $this
            ->setDescription($description)
            ->setDisplayName($displayName)
            ->setFlowRequired($flowRequired)
            ->setFree($free)
            ->setItems($items)
            ->setMaximum($maximum)
            ->setMinimum($minimum)
            ->setPanelId($panelId);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\ModifierGroup
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \StructType\ModifierGroup
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get FlowRequired value
     * @return bool|null
     */
    public function getFlowRequired()
    {
        return $this->FlowRequired;
    }
    /**
     * Set FlowRequired value
     * @param bool $flowRequired
     * @return \StructType\ModifierGroup
     */
    public function setFlowRequired($flowRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($flowRequired) && !is_bool($flowRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($flowRequired)), __LINE__);
        }
        $this->FlowRequired = $flowRequired;
        return $this;
    }
    /**
     * Get Free value
     * @return string|null
     */
    public function getFree()
    {
        return $this->Free;
    }
    /**
     * Set Free value
     * @param string $free
     * @return \StructType\ModifierGroup
     */
    public function setFree($free = null)
    {
        // validation for constraint: string
        if (!is_null($free) && !is_string($free)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($free)), __LINE__);
        }
        $this->Free = $free;
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfModifierGroupItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfModifierGroupItem $items
     * @return \StructType\ModifierGroup
     */
    public function setItems(\ArrayType\ArrayOfModifierGroupItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get Maximum value
     * @return string|null
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param string $maximum
     * @return \StructType\ModifierGroup
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: string
        if (!is_null($maximum) && !is_string($maximum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($maximum)), __LINE__);
        }
        $this->Maximum = $maximum;
        return $this;
    }
    /**
     * Get Minimum value
     * @return string|null
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }
    /**
     * Set Minimum value
     * @param string $minimum
     * @return \StructType\ModifierGroup
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: string
        if (!is_null($minimum) && !is_string($minimum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minimum)), __LINE__);
        }
        $this->Minimum = $minimum;
        return $this;
    }
    /**
     * Get PanelId value
     * @return int|null
     */
    public function getPanelId()
    {
        return $this->PanelId;
    }
    /**
     * Set PanelId value
     * @param int $panelId
     * @return \StructType\ModifierGroup
     */
    public function setPanelId($panelId = null)
    {
        // validation for constraint: int
        if (!is_null($panelId) && !is_numeric($panelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($panelId)), __LINE__);
        }
        $this->PanelId = $panelId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModifierGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
