<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemIncludedModifier StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemIncludedModifier
 * @subpackage Structs
 */
class ItemIncludedModifier extends AbstractStructBase
{
    /**
     * The AutomaticallyAdd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AutomaticallyAdd;
    /**
     * The IsIncluded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsIncluded;
    /**
     * The ItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The ModifierGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ModifierGroupId;
    /**
     * The Position
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Position;
    /**
     * The PrintInKitchen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PrintInKitchen;
    /**
     * Constructor method for ItemIncludedModifier
     * @uses ItemIncludedModifier::setAutomaticallyAdd()
     * @uses ItemIncludedModifier::setIsIncluded()
     * @uses ItemIncludedModifier::setItemId()
     * @uses ItemIncludedModifier::setModifierGroupId()
     * @uses ItemIncludedModifier::setPosition()
     * @uses ItemIncludedModifier::setPrintInKitchen()
     * @param bool $automaticallyAdd
     * @param bool $isIncluded
     * @param int $itemId
     * @param int $modifierGroupId
     * @param int $position
     * @param bool $printInKitchen
     */
    public function __construct($automaticallyAdd = null, $isIncluded = null, $itemId = null, $modifierGroupId = null, $position = null, $printInKitchen = null)
    {
        $this
            ->setAutomaticallyAdd($automaticallyAdd)
            ->setIsIncluded($isIncluded)
            ->setItemId($itemId)
            ->setModifierGroupId($modifierGroupId)
            ->setPosition($position)
            ->setPrintInKitchen($printInKitchen);
    }
    /**
     * Get AutomaticallyAdd value
     * @return bool|null
     */
    public function getAutomaticallyAdd()
    {
        return $this->AutomaticallyAdd;
    }
    /**
     * Set AutomaticallyAdd value
     * @param bool $automaticallyAdd
     * @return \StructType\ItemIncludedModifier
     */
    public function setAutomaticallyAdd($automaticallyAdd = null)
    {
        // validation for constraint: boolean
        if (!is_null($automaticallyAdd) && !is_bool($automaticallyAdd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($automaticallyAdd)), __LINE__);
        }
        $this->AutomaticallyAdd = $automaticallyAdd;
        return $this;
    }
    /**
     * Get IsIncluded value
     * @return bool|null
     */
    public function getIsIncluded()
    {
        return $this->IsIncluded;
    }
    /**
     * Set IsIncluded value
     * @param bool $isIncluded
     * @return \StructType\ItemIncludedModifier
     */
    public function setIsIncluded($isIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncluded) && !is_bool($isIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isIncluded)), __LINE__);
        }
        $this->IsIncluded = $isIncluded;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \StructType\ItemIncludedModifier
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !is_numeric($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ModifierGroupId value
     * @return int|null
     */
    public function getModifierGroupId()
    {
        return $this->ModifierGroupId;
    }
    /**
     * Set ModifierGroupId value
     * @param int $modifierGroupId
     * @return \StructType\ItemIncludedModifier
     */
    public function setModifierGroupId($modifierGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($modifierGroupId) && !is_numeric($modifierGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($modifierGroupId)), __LINE__);
        }
        $this->ModifierGroupId = $modifierGroupId;
        return $this;
    }
    /**
     * Get Position value
     * @return int|null
     */
    public function getPosition()
    {
        return $this->Position;
    }
    /**
     * Set Position value
     * @param int $position
     * @return \StructType\ItemIncludedModifier
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !is_numeric($position)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($position)), __LINE__);
        }
        $this->Position = $position;
        return $this;
    }
    /**
     * Get PrintInKitchen value
     * @return bool|null
     */
    public function getPrintInKitchen()
    {
        return $this->PrintInKitchen;
    }
    /**
     * Set PrintInKitchen value
     * @param bool $printInKitchen
     * @return \StructType\ItemIncludedModifier
     */
    public function setPrintInKitchen($printInKitchen = null)
    {
        // validation for constraint: boolean
        if (!is_null($printInKitchen) && !is_bool($printInKitchen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($printInKitchen)), __LINE__);
        }
        $this->PrintInKitchen = $printInKitchen;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ItemIncludedModifier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
