<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Item
 * @subpackage Structs
 */
class Item extends SettingsObject
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The AskName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AskName;
    /**
     * The AskPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AskPrice;
    /**
     * The AvailableFriday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableFriday;
    /**
     * The AvailableMonday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableMonday;
    /**
     * The AvailableSaturday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableSaturday;
    /**
     * The AvailableSelectDates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableSelectDates;
    /**
     * The AvailableSelectDays
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableSelectDays;
    /**
     * The AvailableSunday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableSunday;
    /**
     * The AvailableThursday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableThursday;
    /**
     * The AvailableTuesday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableTuesday;
    /**
     * The AvailableWednesday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AvailableWednesday;
    /**
     * The BrandAllocations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBrandAllocation
     */
    public $BrandAllocations;
    /**
     * The Components
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfItemCompositeComponent
     */
    public $Components;
    /**
     * The Cost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Cost;
    /**
     * The CreatedTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedTime;
    /**
     * The DatesAvailable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateRange
     */
    public $DatesAvailable;
    /**
     * The GiftCardItemType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $GiftCardItemType;
    /**
     * The IncludedModifiers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfItemIncludedModifier
     */
    public $IncludedModifiers;
    /**
     * The IngredientItemIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $IngredientItemIds;
    /**
     * The IsCombo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCombo;
    /**
     * The IsGiftCard
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsGiftCard;
    /**
     * The IsQuantityCounted
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsQuantityCounted;
    /**
     * The ItemType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ItemType;
    /**
     * The KitchenName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $KitchenName;
    /**
     * The LastEditedTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LastEditedTime;
    /**
     * The ModifierGroupIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $ModifierGroupIds;
    /**
     * The ModifierTierId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ModifierTierId;
    /**
     * The ModifierWeight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ModifierWeight;
    /**
     * The NonRevenueItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $NonRevenueItem;
    /**
     * The PLU
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PLU;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Price;
    /**
     * The PriceLevel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PriceLevel;
    /**
     * The PricePer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PricePer;
    /**
     * The PrinterGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PrinterGroupId;
    /**
     * The RevenueCenterId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RevenueCenterId;
    /**
     * The SortPriority
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SortPriority;
    /**
     * The TareId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TareId;
    /**
     * The TaxIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $TaxIds;
    /**
     * The UnitName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnitName;
    /**
     * The UnitPrecision
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UnitPrecision;
    /**
     * The VideoGroupId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $VideoGroupId;
    /**
     * Constructor method for Item
     * @uses Item::setActive()
     * @uses Item::setAskName()
     * @uses Item::setAskPrice()
     * @uses Item::setAvailableFriday()
     * @uses Item::setAvailableMonday()
     * @uses Item::setAvailableSaturday()
     * @uses Item::setAvailableSelectDates()
     * @uses Item::setAvailableSelectDays()
     * @uses Item::setAvailableSunday()
     * @uses Item::setAvailableThursday()
     * @uses Item::setAvailableTuesday()
     * @uses Item::setAvailableWednesday()
     * @uses Item::setBrandAllocations()
     * @uses Item::setComponents()
     * @uses Item::setCost()
     * @uses Item::setCreatedTime()
     * @uses Item::setDatesAvailable()
     * @uses Item::setGiftCardItemType()
     * @uses Item::setIncludedModifiers()
     * @uses Item::setIngredientItemIds()
     * @uses Item::setIsCombo()
     * @uses Item::setIsGiftCard()
     * @uses Item::setIsQuantityCounted()
     * @uses Item::setItemType()
     * @uses Item::setKitchenName()
     * @uses Item::setLastEditedTime()
     * @uses Item::setModifierGroupIds()
     * @uses Item::setModifierTierId()
     * @uses Item::setModifierWeight()
     * @uses Item::setNonRevenueItem()
     * @uses Item::setPLU()
     * @uses Item::setPrice()
     * @uses Item::setPriceLevel()
     * @uses Item::setPricePer()
     * @uses Item::setPrinterGroupId()
     * @uses Item::setRevenueCenterId()
     * @uses Item::setSortPriority()
     * @uses Item::setTareId()
     * @uses Item::setTaxIds()
     * @uses Item::setUnitName()
     * @uses Item::setUnitPrecision()
     * @uses Item::setVideoGroupId()
     * @param bool $active
     * @param bool $askName
     * @param bool $askPrice
     * @param bool $availableFriday
     * @param bool $availableMonday
     * @param bool $availableSaturday
     * @param bool $availableSelectDates
     * @param bool $availableSelectDays
     * @param bool $availableSunday
     * @param bool $availableThursday
     * @param bool $availableTuesday
     * @param bool $availableWednesday
     * @param \ArrayType\ArrayOfBrandAllocation $brandAllocations
     * @param \ArrayType\ArrayOfItemCompositeComponent $components
     * @param float $cost
     * @param string $createdTime
     * @param \StructType\DateRange $datesAvailable
     * @param string $giftCardItemType
     * @param \ArrayType\ArrayOfItemIncludedModifier $includedModifiers
     * @param \ArrayType\ArrayOfint $ingredientItemIds
     * @param bool $isCombo
     * @param bool $isGiftCard
     * @param bool $isQuantityCounted
     * @param string $itemType
     * @param string $kitchenName
     * @param string $lastEditedTime
     * @param \ArrayType\ArrayOfint $modifierGroupIds
     * @param int $modifierTierId
     * @param string $modifierWeight
     * @param bool $nonRevenueItem
     * @param string $pLU
     * @param float $price
     * @param string $priceLevel
     * @param string $pricePer
     * @param int $printerGroupId
     * @param int $revenueCenterId
     * @param string $sortPriority
     * @param int $tareId
     * @param \ArrayType\ArrayOfint $taxIds
     * @param string $unitName
     * @param string $unitPrecision
     * @param int $videoGroupId
     */
    public function __construct($active = null, $askName = null, $askPrice = null, $availableFriday = null, $availableMonday = null, $availableSaturday = null, $availableSelectDates = null, $availableSelectDays = null, $availableSunday = null, $availableThursday = null, $availableTuesday = null, $availableWednesday = null, \ArrayType\ArrayOfBrandAllocation $brandAllocations = null, \ArrayType\ArrayOfItemCompositeComponent $components = null, $cost = null, $createdTime = null, \StructType\DateRange $datesAvailable = null, $giftCardItemType = null, \ArrayType\ArrayOfItemIncludedModifier $includedModifiers = null, \ArrayType\ArrayOfint $ingredientItemIds = null, $isCombo = null, $isGiftCard = null, $isQuantityCounted = null, $itemType = null, $kitchenName = null, $lastEditedTime = null, \ArrayType\ArrayOfint $modifierGroupIds = null, $modifierTierId = null, $modifierWeight = null, $nonRevenueItem = null, $pLU = null, $price = null, $priceLevel = null, $pricePer = null, $printerGroupId = null, $revenueCenterId = null, $sortPriority = null, $tareId = null, \ArrayType\ArrayOfint $taxIds = null, $unitName = null, $unitPrecision = null, $videoGroupId = null)
    {
        $this
            ->setActive($active)
            ->setAskName($askName)
            ->setAskPrice($askPrice)
            ->setAvailableFriday($availableFriday)
            ->setAvailableMonday($availableMonday)
            ->setAvailableSaturday($availableSaturday)
            ->setAvailableSelectDates($availableSelectDates)
            ->setAvailableSelectDays($availableSelectDays)
            ->setAvailableSunday($availableSunday)
            ->setAvailableThursday($availableThursday)
            ->setAvailableTuesday($availableTuesday)
            ->setAvailableWednesday($availableWednesday)
            ->setBrandAllocations($brandAllocations)
            ->setComponents($components)
            ->setCost($cost)
            ->setCreatedTime($createdTime)
            ->setDatesAvailable($datesAvailable)
            ->setGiftCardItemType($giftCardItemType)
            ->setIncludedModifiers($includedModifiers)
            ->setIngredientItemIds($ingredientItemIds)
            ->setIsCombo($isCombo)
            ->setIsGiftCard($isGiftCard)
            ->setIsQuantityCounted($isQuantityCounted)
            ->setItemType($itemType)
            ->setKitchenName($kitchenName)
            ->setLastEditedTime($lastEditedTime)
            ->setModifierGroupIds($modifierGroupIds)
            ->setModifierTierId($modifierTierId)
            ->setModifierWeight($modifierWeight)
            ->setNonRevenueItem($nonRevenueItem)
            ->setPLU($pLU)
            ->setPrice($price)
            ->setPriceLevel($priceLevel)
            ->setPricePer($pricePer)
            ->setPrinterGroupId($printerGroupId)
            ->setRevenueCenterId($revenueCenterId)
            ->setSortPriority($sortPriority)
            ->setTareId($tareId)
            ->setTaxIds($taxIds)
            ->setUnitName($unitName)
            ->setUnitPrecision($unitPrecision)
            ->setVideoGroupId($videoGroupId);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Item
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AskName value
     * @return bool|null
     */
    public function getAskName()
    {
        return $this->AskName;
    }
    /**
     * Set AskName value
     * @param bool $askName
     * @return \StructType\Item
     */
    public function setAskName($askName = null)
    {
        // validation for constraint: boolean
        if (!is_null($askName) && !is_bool($askName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($askName)), __LINE__);
        }
        $this->AskName = $askName;
        return $this;
    }
    /**
     * Get AskPrice value
     * @return bool|null
     */
    public function getAskPrice()
    {
        return $this->AskPrice;
    }
    /**
     * Set AskPrice value
     * @param bool $askPrice
     * @return \StructType\Item
     */
    public function setAskPrice($askPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($askPrice) && !is_bool($askPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($askPrice)), __LINE__);
        }
        $this->AskPrice = $askPrice;
        return $this;
    }
    /**
     * Get AvailableFriday value
     * @return bool|null
     */
    public function getAvailableFriday()
    {
        return $this->AvailableFriday;
    }
    /**
     * Set AvailableFriday value
     * @param bool $availableFriday
     * @return \StructType\Item
     */
    public function setAvailableFriday($availableFriday = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableFriday) && !is_bool($availableFriday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableFriday)), __LINE__);
        }
        $this->AvailableFriday = $availableFriday;
        return $this;
    }
    /**
     * Get AvailableMonday value
     * @return bool|null
     */
    public function getAvailableMonday()
    {
        return $this->AvailableMonday;
    }
    /**
     * Set AvailableMonday value
     * @param bool $availableMonday
     * @return \StructType\Item
     */
    public function setAvailableMonday($availableMonday = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableMonday) && !is_bool($availableMonday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableMonday)), __LINE__);
        }
        $this->AvailableMonday = $availableMonday;
        return $this;
    }
    /**
     * Get AvailableSaturday value
     * @return bool|null
     */
    public function getAvailableSaturday()
    {
        return $this->AvailableSaturday;
    }
    /**
     * Set AvailableSaturday value
     * @param bool $availableSaturday
     * @return \StructType\Item
     */
    public function setAvailableSaturday($availableSaturday = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableSaturday) && !is_bool($availableSaturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableSaturday)), __LINE__);
        }
        $this->AvailableSaturday = $availableSaturday;
        return $this;
    }
    /**
     * Get AvailableSelectDates value
     * @return bool|null
     */
    public function getAvailableSelectDates()
    {
        return $this->AvailableSelectDates;
    }
    /**
     * Set AvailableSelectDates value
     * @param bool $availableSelectDates
     * @return \StructType\Item
     */
    public function setAvailableSelectDates($availableSelectDates = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableSelectDates) && !is_bool($availableSelectDates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableSelectDates)), __LINE__);
        }
        $this->AvailableSelectDates = $availableSelectDates;
        return $this;
    }
    /**
     * Get AvailableSelectDays value
     * @return bool|null
     */
    public function getAvailableSelectDays()
    {
        return $this->AvailableSelectDays;
    }
    /**
     * Set AvailableSelectDays value
     * @param bool $availableSelectDays
     * @return \StructType\Item
     */
    public function setAvailableSelectDays($availableSelectDays = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableSelectDays) && !is_bool($availableSelectDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableSelectDays)), __LINE__);
        }
        $this->AvailableSelectDays = $availableSelectDays;
        return $this;
    }
    /**
     * Get AvailableSunday value
     * @return bool|null
     */
    public function getAvailableSunday()
    {
        return $this->AvailableSunday;
    }
    /**
     * Set AvailableSunday value
     * @param bool $availableSunday
     * @return \StructType\Item
     */
    public function setAvailableSunday($availableSunday = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableSunday) && !is_bool($availableSunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableSunday)), __LINE__);
        }
        $this->AvailableSunday = $availableSunday;
        return $this;
    }
    /**
     * Get AvailableThursday value
     * @return bool|null
     */
    public function getAvailableThursday()
    {
        return $this->AvailableThursday;
    }
    /**
     * Set AvailableThursday value
     * @param bool $availableThursday
     * @return \StructType\Item
     */
    public function setAvailableThursday($availableThursday = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableThursday) && !is_bool($availableThursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableThursday)), __LINE__);
        }
        $this->AvailableThursday = $availableThursday;
        return $this;
    }
    /**
     * Get AvailableTuesday value
     * @return bool|null
     */
    public function getAvailableTuesday()
    {
        return $this->AvailableTuesday;
    }
    /**
     * Set AvailableTuesday value
     * @param bool $availableTuesday
     * @return \StructType\Item
     */
    public function setAvailableTuesday($availableTuesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableTuesday) && !is_bool($availableTuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableTuesday)), __LINE__);
        }
        $this->AvailableTuesday = $availableTuesday;
        return $this;
    }
    /**
     * Get AvailableWednesday value
     * @return bool|null
     */
    public function getAvailableWednesday()
    {
        return $this->AvailableWednesday;
    }
    /**
     * Set AvailableWednesday value
     * @param bool $availableWednesday
     * @return \StructType\Item
     */
    public function setAvailableWednesday($availableWednesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($availableWednesday) && !is_bool($availableWednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($availableWednesday)), __LINE__);
        }
        $this->AvailableWednesday = $availableWednesday;
        return $this;
    }
    /**
     * Get BrandAllocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBrandAllocation|null
     */
    public function getBrandAllocations()
    {
        return isset($this->BrandAllocations) ? $this->BrandAllocations : null;
    }
    /**
     * Set BrandAllocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBrandAllocation $brandAllocations
     * @return \StructType\Item
     */
    public function setBrandAllocations(\ArrayType\ArrayOfBrandAllocation $brandAllocations = null)
    {
        if (is_null($brandAllocations) || (is_array($brandAllocations) && empty($brandAllocations))) {
            unset($this->BrandAllocations);
        } else {
            $this->BrandAllocations = $brandAllocations;
        }
        return $this;
    }
    /**
     * Get Components value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfItemCompositeComponent|null
     */
    public function getComponents()
    {
        return isset($this->Components) ? $this->Components : null;
    }
    /**
     * Set Components value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfItemCompositeComponent $components
     * @return \StructType\Item
     */
    public function setComponents(\ArrayType\ArrayOfItemCompositeComponent $components = null)
    {
        if (is_null($components) || (is_array($components) && empty($components))) {
            unset($this->Components);
        } else {
            $this->Components = $components;
        }
        return $this;
    }
    /**
     * Get Cost value
     * @return float|null
     */
    public function getCost()
    {
        return $this->Cost;
    }
    /**
     * Set Cost value
     * @param float $cost
     * @return \StructType\Item
     */
    public function setCost($cost = null)
    {
        $this->Cost = $cost;
        return $this;
    }
    /**
     * Get CreatedTime value
     * @return string|null
     */
    public function getCreatedTime()
    {
        return $this->CreatedTime;
    }
    /**
     * Set CreatedTime value
     * @param string $createdTime
     * @return \StructType\Item
     */
    public function setCreatedTime($createdTime = null)
    {
        // validation for constraint: string
        if (!is_null($createdTime) && !is_string($createdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdTime)), __LINE__);
        }
        $this->CreatedTime = $createdTime;
        return $this;
    }
    /**
     * Get DatesAvailable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateRange|null
     */
    public function getDatesAvailable()
    {
        return isset($this->DatesAvailable) ? $this->DatesAvailable : null;
    }
    /**
     * Set DatesAvailable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateRange $datesAvailable
     * @return \StructType\Item
     */
    public function setDatesAvailable(\StructType\DateRange $datesAvailable = null)
    {
        if (is_null($datesAvailable) || (is_array($datesAvailable) && empty($datesAvailable))) {
            unset($this->DatesAvailable);
        } else {
            $this->DatesAvailable = $datesAvailable;
        }
        return $this;
    }
    /**
     * Get GiftCardItemType value
     * @return string|null
     */
    public function getGiftCardItemType()
    {
        return $this->GiftCardItemType;
    }
    /**
     * Set GiftCardItemType value
     * @uses \EnumType\GiftCardItemType::valueIsValid()
     * @uses \EnumType\GiftCardItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $giftCardItemType
     * @return \StructType\Item
     */
    public function setGiftCardItemType($giftCardItemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GiftCardItemType::valueIsValid($giftCardItemType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $giftCardItemType, implode(', ', \EnumType\GiftCardItemType::getValidValues())), __LINE__);
        }
        $this->GiftCardItemType = $giftCardItemType;
        return $this;
    }
    /**
     * Get IncludedModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfItemIncludedModifier|null
     */
    public function getIncludedModifiers()
    {
        return isset($this->IncludedModifiers) ? $this->IncludedModifiers : null;
    }
    /**
     * Set IncludedModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfItemIncludedModifier $includedModifiers
     * @return \StructType\Item
     */
    public function setIncludedModifiers(\ArrayType\ArrayOfItemIncludedModifier $includedModifiers = null)
    {
        if (is_null($includedModifiers) || (is_array($includedModifiers) && empty($includedModifiers))) {
            unset($this->IncludedModifiers);
        } else {
            $this->IncludedModifiers = $includedModifiers;
        }
        return $this;
    }
    /**
     * Get IngredientItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getIngredientItemIds()
    {
        return isset($this->IngredientItemIds) ? $this->IngredientItemIds : null;
    }
    /**
     * Set IngredientItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $ingredientItemIds
     * @return \StructType\Item
     */
    public function setIngredientItemIds(\ArrayType\ArrayOfint $ingredientItemIds = null)
    {
        if (is_null($ingredientItemIds) || (is_array($ingredientItemIds) && empty($ingredientItemIds))) {
            unset($this->IngredientItemIds);
        } else {
            $this->IngredientItemIds = $ingredientItemIds;
        }
        return $this;
    }
    /**
     * Get IsCombo value
     * @return bool|null
     */
    public function getIsCombo()
    {
        return $this->IsCombo;
    }
    /**
     * Set IsCombo value
     * @param bool $isCombo
     * @return \StructType\Item
     */
    public function setIsCombo($isCombo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCombo) && !is_bool($isCombo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCombo)), __LINE__);
        }
        $this->IsCombo = $isCombo;
        return $this;
    }
    /**
     * Get IsGiftCard value
     * @return bool|null
     */
    public function getIsGiftCard()
    {
        return $this->IsGiftCard;
    }
    /**
     * Set IsGiftCard value
     * @param bool $isGiftCard
     * @return \StructType\Item
     */
    public function setIsGiftCard($isGiftCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGiftCard) && !is_bool($isGiftCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isGiftCard)), __LINE__);
        }
        $this->IsGiftCard = $isGiftCard;
        return $this;
    }
    /**
     * Get IsQuantityCounted value
     * @return bool|null
     */
    public function getIsQuantityCounted()
    {
        return $this->IsQuantityCounted;
    }
    /**
     * Set IsQuantityCounted value
     * @param bool $isQuantityCounted
     * @return \StructType\Item
     */
    public function setIsQuantityCounted($isQuantityCounted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQuantityCounted) && !is_bool($isQuantityCounted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isQuantityCounted)), __LINE__);
        }
        $this->IsQuantityCounted = $isQuantityCounted;
        return $this;
    }
    /**
     * Get ItemType value
     * @return string|null
     */
    public function getItemType()
    {
        return $this->ItemType;
    }
    /**
     * Set ItemType value
     * @uses \EnumType\ItemType::valueIsValid()
     * @uses \EnumType\ItemType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $itemType
     * @return \StructType\Item
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ItemType::valueIsValid($itemType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $itemType, implode(', ', \EnumType\ItemType::getValidValues())), __LINE__);
        }
        $this->ItemType = $itemType;
        return $this;
    }
    /**
     * Get KitchenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKitchenName()
    {
        return isset($this->KitchenName) ? $this->KitchenName : null;
    }
    /**
     * Set KitchenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kitchenName
     * @return \StructType\Item
     */
    public function setKitchenName($kitchenName = null)
    {
        // validation for constraint: string
        if (!is_null($kitchenName) && !is_string($kitchenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kitchenName)), __LINE__);
        }
        if (is_null($kitchenName) || (is_array($kitchenName) && empty($kitchenName))) {
            unset($this->KitchenName);
        } else {
            $this->KitchenName = $kitchenName;
        }
        return $this;
    }
    /**
     * Get LastEditedTime value
     * @return string|null
     */
    public function getLastEditedTime()
    {
        return $this->LastEditedTime;
    }
    /**
     * Set LastEditedTime value
     * @param string $lastEditedTime
     * @return \StructType\Item
     */
    public function setLastEditedTime($lastEditedTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastEditedTime) && !is_string($lastEditedTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastEditedTime)), __LINE__);
        }
        $this->LastEditedTime = $lastEditedTime;
        return $this;
    }
    /**
     * Get ModifierGroupIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getModifierGroupIds()
    {
        return isset($this->ModifierGroupIds) ? $this->ModifierGroupIds : null;
    }
    /**
     * Set ModifierGroupIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $modifierGroupIds
     * @return \StructType\Item
     */
    public function setModifierGroupIds(\ArrayType\ArrayOfint $modifierGroupIds = null)
    {
        if (is_null($modifierGroupIds) || (is_array($modifierGroupIds) && empty($modifierGroupIds))) {
            unset($this->ModifierGroupIds);
        } else {
            $this->ModifierGroupIds = $modifierGroupIds;
        }
        return $this;
    }
    /**
     * Get ModifierTierId value
     * @return int|null
     */
    public function getModifierTierId()
    {
        return $this->ModifierTierId;
    }
    /**
     * Set ModifierTierId value
     * @param int $modifierTierId
     * @return \StructType\Item
     */
    public function setModifierTierId($modifierTierId = null)
    {
        // validation for constraint: int
        if (!is_null($modifierTierId) && !is_numeric($modifierTierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($modifierTierId)), __LINE__);
        }
        $this->ModifierTierId = $modifierTierId;
        return $this;
    }
    /**
     * Get ModifierWeight value
     * @return string|null
     */
    public function getModifierWeight()
    {
        return $this->ModifierWeight;
    }
    /**
     * Set ModifierWeight value
     * @param string $modifierWeight
     * @return \StructType\Item
     */
    public function setModifierWeight($modifierWeight = null)
    {
        // validation for constraint: string
        if (!is_null($modifierWeight) && !is_string($modifierWeight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modifierWeight)), __LINE__);
        }
        $this->ModifierWeight = $modifierWeight;
        return $this;
    }
    /**
     * Get NonRevenueItem value
     * @return bool|null
     */
    public function getNonRevenueItem()
    {
        return $this->NonRevenueItem;
    }
    /**
     * Set NonRevenueItem value
     * @param bool $nonRevenueItem
     * @return \StructType\Item
     */
    public function setNonRevenueItem($nonRevenueItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($nonRevenueItem) && !is_bool($nonRevenueItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($nonRevenueItem)), __LINE__);
        }
        $this->NonRevenueItem = $nonRevenueItem;
        return $this;
    }
    /**
     * Get PLU value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPLU()
    {
        return isset($this->PLU) ? $this->PLU : null;
    }
    /**
     * Set PLU value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pLU
     * @return \StructType\Item
     */
    public function setPLU($pLU = null)
    {
        // validation for constraint: string
        if (!is_null($pLU) && !is_string($pLU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pLU)), __LINE__);
        }
        if (is_null($pLU) || (is_array($pLU) && empty($pLU))) {
            unset($this->PLU);
        } else {
            $this->PLU = $pLU;
        }
        return $this;
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \StructType\Item
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceLevel value
     * @return string|null
     */
    public function getPriceLevel()
    {
        return $this->PriceLevel;
    }
    /**
     * Set PriceLevel value
     * @param string $priceLevel
     * @return \StructType\Item
     */
    public function setPriceLevel($priceLevel = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevel) && !is_string($priceLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priceLevel)), __LINE__);
        }
        $this->PriceLevel = $priceLevel;
        return $this;
    }
    /**
     * Get PricePer value
     * @return string|null
     */
    public function getPricePer()
    {
        return $this->PricePer;
    }
    /**
     * Set PricePer value
     * @uses \EnumType\PricePer::valueIsValid()
     * @uses \EnumType\PricePer::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricePer
     * @return \StructType\Item
     */
    public function setPricePer($pricePer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricePer::valueIsValid($pricePer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pricePer, implode(', ', \EnumType\PricePer::getValidValues())), __LINE__);
        }
        $this->PricePer = $pricePer;
        return $this;
    }
    /**
     * Get PrinterGroupId value
     * @return int|null
     */
    public function getPrinterGroupId()
    {
        return $this->PrinterGroupId;
    }
    /**
     * Set PrinterGroupId value
     * @param int $printerGroupId
     * @return \StructType\Item
     */
    public function setPrinterGroupId($printerGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($printerGroupId) && !is_numeric($printerGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($printerGroupId)), __LINE__);
        }
        $this->PrinterGroupId = $printerGroupId;
        return $this;
    }
    /**
     * Get RevenueCenterId value
     * @return int|null
     */
    public function getRevenueCenterId()
    {
        return $this->RevenueCenterId;
    }
    /**
     * Set RevenueCenterId value
     * @param int $revenueCenterId
     * @return \StructType\Item
     */
    public function setRevenueCenterId($revenueCenterId = null)
    {
        // validation for constraint: int
        if (!is_null($revenueCenterId) && !is_numeric($revenueCenterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($revenueCenterId)), __LINE__);
        }
        $this->RevenueCenterId = $revenueCenterId;
        return $this;
    }
    /**
     * Get SortPriority value
     * @return string|null
     */
    public function getSortPriority()
    {
        return $this->SortPriority;
    }
    /**
     * Set SortPriority value
     * @param string $sortPriority
     * @return \StructType\Item
     */
    public function setSortPriority($sortPriority = null)
    {
        // validation for constraint: string
        if (!is_null($sortPriority) && !is_string($sortPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sortPriority)), __LINE__);
        }
        $this->SortPriority = $sortPriority;
        return $this;
    }
    /**
     * Get TareId value
     * @return int|null
     */
    public function getTareId()
    {
        return $this->TareId;
    }
    /**
     * Set TareId value
     * @param int $tareId
     * @return \StructType\Item
     */
    public function setTareId($tareId = null)
    {
        // validation for constraint: int
        if (!is_null($tareId) && !is_numeric($tareId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tareId)), __LINE__);
        }
        $this->TareId = $tareId;
        return $this;
    }
    /**
     * Get TaxIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getTaxIds()
    {
        return isset($this->TaxIds) ? $this->TaxIds : null;
    }
    /**
     * Set TaxIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $taxIds
     * @return \StructType\Item
     */
    public function setTaxIds(\ArrayType\ArrayOfint $taxIds = null)
    {
        if (is_null($taxIds) || (is_array($taxIds) && empty($taxIds))) {
            unset($this->TaxIds);
        } else {
            $this->TaxIds = $taxIds;
        }
        return $this;
    }
    /**
     * Get UnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnitName()
    {
        return isset($this->UnitName) ? $this->UnitName : null;
    }
    /**
     * Set UnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unitName
     * @return \StructType\Item
     */
    public function setUnitName($unitName = null)
    {
        // validation for constraint: string
        if (!is_null($unitName) && !is_string($unitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitName)), __LINE__);
        }
        if (is_null($unitName) || (is_array($unitName) && empty($unitName))) {
            unset($this->UnitName);
        } else {
            $this->UnitName = $unitName;
        }
        return $this;
    }
    /**
     * Get UnitPrecision value
     * @return string|null
     */
    public function getUnitPrecision()
    {
        return $this->UnitPrecision;
    }
    /**
     * Set UnitPrecision value
     * @param string $unitPrecision
     * @return \StructType\Item
     */
    public function setUnitPrecision($unitPrecision = null)
    {
        // validation for constraint: string
        if (!is_null($unitPrecision) && !is_string($unitPrecision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unitPrecision)), __LINE__);
        }
        $this->UnitPrecision = $unitPrecision;
        return $this;
    }
    /**
     * Get VideoGroupId value
     * @return int|null
     */
    public function getVideoGroupId()
    {
        return $this->VideoGroupId;
    }
    /**
     * Set VideoGroupId value
     * @param int $videoGroupId
     * @return \StructType\Item
     */
    public function setVideoGroupId($videoGroupId = null)
    {
        // validation for constraint: int
        if (!is_null($videoGroupId) && !is_numeric($videoGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($videoGroupId)), __LINE__);
        }
        $this->VideoGroupId = $videoGroupId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
