<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GLExportTaxAccount StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GLExportTaxAccount
 * @subpackage Structs
 */
class GLExportTaxAccount extends GLExportAccount
{
    /**
     * The TaxId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaxId;
    /**
     * Constructor method for GLExportTaxAccount
     * @uses GLExportTaxAccount::setTaxId()
     * @param int $taxId
     */
    public function __construct($taxId = null)
    {
        $this
            ->setTaxId($taxId);
    }
    /**
     * Get TaxId value
     * @return int|null
     */
    public function getTaxId()
    {
        return $this->TaxId;
    }
    /**
     * Set TaxId value
     * @param int $taxId
     * @return \StructType\GLExportTaxAccount
     */
    public function setTaxId($taxId = null)
    {
        // validation for constraint: int
        if (!is_null($taxId) && !is_numeric($taxId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taxId)), __LINE__);
        }
        $this->TaxId = $taxId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GLExportTaxAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
