<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Employee StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Employee
 * @subpackage Structs
 */
class Employee extends AbstractStructBase
{
    /**
     * The Address1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address1;
    /**
     * The Address2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Address2;
    /**
     * The BirthDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BirthDate;
    /**
     * The CellPhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CellPhone;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $City;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The FirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The HireDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $HireDate;
    /**
     * The HomePhone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IdentificationVerified
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IdentificationVerified;
    /**
     * The Jobs
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmployeeJobs
     */
    public $Jobs;
    /**
     * The LastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MaritalStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $MaritalStatus;
    /**
     * The MiddleName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The PayrollId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayrollId;
    /**
     * The SSN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SSN;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TaxWithholdingAllowance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TaxWithholdingAllowance;
    /**
     * The Terminated
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Terminated;
    /**
     * The TerminationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TerminationDate;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Zip;
    /**
     * Constructor method for Employee
     * @uses Employee::setAddress1()
     * @uses Employee::setAddress2()
     * @uses Employee::setBirthDate()
     * @uses Employee::setCellPhone()
     * @uses Employee::setCity()
     * @uses Employee::setEmailAddress()
     * @uses Employee::setFirstName()
     * @uses Employee::setHireDate()
     * @uses Employee::setHomePhone()
     * @uses Employee::setId()
     * @uses Employee::setIdentificationVerified()
     * @uses Employee::setJobs()
     * @uses Employee::setLastName()
     * @uses Employee::setMaritalStatus()
     * @uses Employee::setMiddleName()
     * @uses Employee::setName()
     * @uses Employee::setNotes()
     * @uses Employee::setPayrollId()
     * @uses Employee::setSSN()
     * @uses Employee::setState()
     * @uses Employee::setTaxWithholdingAllowance()
     * @uses Employee::setTerminated()
     * @uses Employee::setTerminationDate()
     * @uses Employee::setZip()
     * @param string $address1
     * @param string $address2
     * @param string $birthDate
     * @param string $cellPhone
     * @param string $city
     * @param string $emailAddress
     * @param string $firstName
     * @param string $hireDate
     * @param string $homePhone
     * @param int $id
     * @param bool $identificationVerified
     * @param \StructType\EmployeeJobs $jobs
     * @param string $lastName
     * @param string $maritalStatus
     * @param string $middleName
     * @param string $name
     * @param string $notes
     * @param string $payrollId
     * @param string $sSN
     * @param string $state
     * @param int $taxWithholdingAllowance
     * @param bool $terminated
     * @param string $terminationDate
     * @param string $zip
     */
    public function __construct($address1 = null, $address2 = null, $birthDate = null, $cellPhone = null, $city = null, $emailAddress = null, $firstName = null, $hireDate = null, $homePhone = null, $id = null, $identificationVerified = null, \StructType\EmployeeJobs $jobs = null, $lastName = null, $maritalStatus = null, $middleName = null, $name = null, $notes = null, $payrollId = null, $sSN = null, $state = null, $taxWithholdingAllowance = null, $terminated = null, $terminationDate = null, $zip = null)
    {
        $this
            ->setAddress1($address1)
            ->setAddress2($address2)
            ->setBirthDate($birthDate)
            ->setCellPhone($cellPhone)
            ->setCity($city)
            ->setEmailAddress($emailAddress)
            ->setFirstName($firstName)
            ->setHireDate($hireDate)
            ->setHomePhone($homePhone)
            ->setId($id)
            ->setIdentificationVerified($identificationVerified)
            ->setJobs($jobs)
            ->setLastName($lastName)
            ->setMaritalStatus($maritalStatus)
            ->setMiddleName($middleName)
            ->setName($name)
            ->setNotes($notes)
            ->setPayrollId($payrollId)
            ->setSSN($sSN)
            ->setState($state)
            ->setTaxWithholdingAllowance($taxWithholdingAllowance)
            ->setTerminated($terminated)
            ->setTerminationDate($terminationDate)
            ->setZip($zip);
    }
    /**
     * Get Address1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress1()
    {
        return isset($this->Address1) ? $this->Address1 : null;
    }
    /**
     * Set Address1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address1
     * @return \StructType\Employee
     */
    public function setAddress1($address1 = null)
    {
        // validation for constraint: string
        if (!is_null($address1) && !is_string($address1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address1)), __LINE__);
        }
        if (is_null($address1) || (is_array($address1) && empty($address1))) {
            unset($this->Address1);
        } else {
            $this->Address1 = $address1;
        }
        return $this;
    }
    /**
     * Get Address2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddress2()
    {
        return isset($this->Address2) ? $this->Address2 : null;
    }
    /**
     * Set Address2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $address2
     * @return \StructType\Employee
     */
    public function setAddress2($address2 = null)
    {
        // validation for constraint: string
        if (!is_null($address2) && !is_string($address2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address2)), __LINE__);
        }
        if (is_null($address2) || (is_array($address2) && empty($address2))) {
            unset($this->Address2);
        } else {
            $this->Address2 = $address2;
        }
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\Employee
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($birthDate)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get CellPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCellPhone()
    {
        return isset($this->CellPhone) ? $this->CellPhone : null;
    }
    /**
     * Set CellPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cellPhone
     * @return \StructType\Employee
     */
    public function setCellPhone($cellPhone = null)
    {
        // validation for constraint: string
        if (!is_null($cellPhone) && !is_string($cellPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cellPhone)), __LINE__);
        }
        if (is_null($cellPhone) || (is_array($cellPhone) && empty($cellPhone))) {
            unset($this->CellPhone);
        } else {
            $this->CellPhone = $cellPhone;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $city
     * @return \StructType\Employee
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \StructType\Employee
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\Employee
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get HireDate value
     * @return string|null
     */
    public function getHireDate()
    {
        return $this->HireDate;
    }
    /**
     * Set HireDate value
     * @param string $hireDate
     * @return \StructType\Employee
     */
    public function setHireDate($hireDate = null)
    {
        // validation for constraint: string
        if (!is_null($hireDate) && !is_string($hireDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hireDate)), __LINE__);
        }
        $this->HireDate = $hireDate;
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \StructType\Employee
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Employee
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IdentificationVerified value
     * @return bool|null
     */
    public function getIdentificationVerified()
    {
        return $this->IdentificationVerified;
    }
    /**
     * Set IdentificationVerified value
     * @param bool $identificationVerified
     * @return \StructType\Employee
     */
    public function setIdentificationVerified($identificationVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($identificationVerified) && !is_bool($identificationVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($identificationVerified)), __LINE__);
        }
        $this->IdentificationVerified = $identificationVerified;
        return $this;
    }
    /**
     * Get Jobs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmployeeJobs|null
     */
    public function getJobs()
    {
        return isset($this->Jobs) ? $this->Jobs : null;
    }
    /**
     * Set Jobs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\EmployeeJobs $jobs
     * @return \StructType\Employee
     */
    public function setJobs(\StructType\EmployeeJobs $jobs = null)
    {
        if (is_null($jobs) || (is_array($jobs) && empty($jobs))) {
            unset($this->Jobs);
        } else {
            $this->Jobs = $jobs;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\Employee
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MaritalStatus value
     * @return string|null
     */
    public function getMaritalStatus()
    {
        return $this->MaritalStatus;
    }
    /**
     * Set MaritalStatus value
     * @uses \EnumType\MaritalStatus::valueIsValid()
     * @uses \EnumType\MaritalStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $maritalStatus
     * @return \StructType\Employee
     */
    public function setMaritalStatus($maritalStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MaritalStatus::valueIsValid($maritalStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $maritalStatus, implode(', ', \EnumType\MaritalStatus::getValidValues())), __LINE__);
        }
        $this->MaritalStatus = $maritalStatus;
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \StructType\Employee
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Employee
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \StructType\Employee
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get PayrollId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayrollId()
    {
        return isset($this->PayrollId) ? $this->PayrollId : null;
    }
    /**
     * Set PayrollId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payrollId
     * @return \StructType\Employee
     */
    public function setPayrollId($payrollId = null)
    {
        // validation for constraint: string
        if (!is_null($payrollId) && !is_string($payrollId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payrollId)), __LINE__);
        }
        if (is_null($payrollId) || (is_array($payrollId) && empty($payrollId))) {
            unset($this->PayrollId);
        } else {
            $this->PayrollId = $payrollId;
        }
        return $this;
    }
    /**
     * Get SSN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSSN()
    {
        return isset($this->SSN) ? $this->SSN : null;
    }
    /**
     * Set SSN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sSN
     * @return \StructType\Employee
     */
    public function setSSN($sSN = null)
    {
        // validation for constraint: string
        if (!is_null($sSN) && !is_string($sSN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sSN)), __LINE__);
        }
        if (is_null($sSN) || (is_array($sSN) && empty($sSN))) {
            unset($this->SSN);
        } else {
            $this->SSN = $sSN;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $state
     * @return \StructType\Employee
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TaxWithholdingAllowance value
     * @return int|null
     */
    public function getTaxWithholdingAllowance()
    {
        return $this->TaxWithholdingAllowance;
    }
    /**
     * Set TaxWithholdingAllowance value
     * @param int $taxWithholdingAllowance
     * @return \StructType\Employee
     */
    public function setTaxWithholdingAllowance($taxWithholdingAllowance = null)
    {
        // validation for constraint: int
        if (!is_null($taxWithholdingAllowance) && !is_numeric($taxWithholdingAllowance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($taxWithholdingAllowance)), __LINE__);
        }
        $this->TaxWithholdingAllowance = $taxWithholdingAllowance;
        return $this;
    }
    /**
     * Get Terminated value
     * @return bool|null
     */
    public function getTerminated()
    {
        return $this->Terminated;
    }
    /**
     * Set Terminated value
     * @param bool $terminated
     * @return \StructType\Employee
     */
    public function setTerminated($terminated = null)
    {
        // validation for constraint: boolean
        if (!is_null($terminated) && !is_bool($terminated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($terminated)), __LINE__);
        }
        $this->Terminated = $terminated;
        return $this;
    }
    /**
     * Get TerminationDate value
     * @return string|null
     */
    public function getTerminationDate()
    {
        return $this->TerminationDate;
    }
    /**
     * Set TerminationDate value
     * @param string $terminationDate
     * @return \StructType\Employee
     */
    public function setTerminationDate($terminationDate = null)
    {
        // validation for constraint: string
        if (!is_null($terminationDate) && !is_string($terminationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($terminationDate)), __LINE__);
        }
        $this->TerminationDate = $terminationDate;
        return $this;
    }
    /**
     * Get Zip value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getZip()
    {
        return isset($this->Zip) ? $this->Zip : null;
    }
    /**
     * Set Zip value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $zip
     * @return \StructType\Employee
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        if (is_null($zip) || (is_array($zip) && empty($zip))) {
            unset($this->Zip);
        } else {
            $this->Zip = $zip;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Employee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
