<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Discount StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Discount
 * @subpackage Structs
 */
class Discount extends AbstractStructBase
{
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The AllowLaterDiscounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowLaterDiscounts;
    /**
     * The AllowPriorDiscounts
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowPriorDiscounts;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Amount;
    /**
     * The DiscountedItemsEligible
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DiscountedItemsEligible;
    /**
     * The EligibleItemGroupIds
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $EligibleItemGroupIds;
    /**
     * The EligibleItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EligibleItemId;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The EndTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndTime;
    /**
     * The EnforceMaximumAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EnforceMaximumAmount;
    /**
     * The EnforceMaximumItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EnforceMaximumItems;
    /**
     * The EnforceMaximumPerOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EnforceMaximumPerOrder;
    /**
     * The ExcludeItemsFromProductMix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludeItemsFromProductMix;
    /**
     * The Friday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Friday;
    /**
     * The Granularity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Granularity;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IsEmployeeDiscount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsEmployeeDiscount;
    /**
     * The IsLoyaltyDiscount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLoyaltyDiscount;
    /**
     * The ManagerNeeded
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ManagerNeeded;
    /**
     * The MaximumAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MaximumAmount;
    /**
     * The MaximumItems
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaximumItems;
    /**
     * The MaximumPerOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaximumPerOrder;
    /**
     * The Monday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Monday;
    /**
     * The MustEnterAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MustEnterAmount;
    /**
     * The MustEnterName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MustEnterName;
    /**
     * The MustEnterPercent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MustEnterPercent;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OpenDrawer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OpenDrawer;
    /**
     * The PrintOrder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PrintOrder;
    /**
     * The PrintedName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedName;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Rate;
    /**
     * The Saturday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Saturday;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The StartTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartTime;
    /**
     * The Sunday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Sunday;
    /**
     * The Thursday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Thursday;
    /**
     * The Tuesday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Tuesday;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The UseDateRangeFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseDateRangeFilter;
    /**
     * The UseDayFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseDayFilter;
    /**
     * The UseItemFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseItemFilter;
    /**
     * The UseItemGroupFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseItemGroupFilter;
    /**
     * The UseTimeRangeFilter
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UseTimeRangeFilter;
    /**
     * The Wednesday
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Wednesday;
    /**
     * Constructor method for Discount
     * @uses Discount::setActive()
     * @uses Discount::setAllowLaterDiscounts()
     * @uses Discount::setAllowPriorDiscounts()
     * @uses Discount::setAmount()
     * @uses Discount::setDiscountedItemsEligible()
     * @uses Discount::setEligibleItemGroupIds()
     * @uses Discount::setEligibleItemId()
     * @uses Discount::setEndDate()
     * @uses Discount::setEndTime()
     * @uses Discount::setEnforceMaximumAmount()
     * @uses Discount::setEnforceMaximumItems()
     * @uses Discount::setEnforceMaximumPerOrder()
     * @uses Discount::setExcludeItemsFromProductMix()
     * @uses Discount::setFriday()
     * @uses Discount::setGranularity()
     * @uses Discount::setId()
     * @uses Discount::setIsEmployeeDiscount()
     * @uses Discount::setIsLoyaltyDiscount()
     * @uses Discount::setManagerNeeded()
     * @uses Discount::setMaximumAmount()
     * @uses Discount::setMaximumItems()
     * @uses Discount::setMaximumPerOrder()
     * @uses Discount::setMonday()
     * @uses Discount::setMustEnterAmount()
     * @uses Discount::setMustEnterName()
     * @uses Discount::setMustEnterPercent()
     * @uses Discount::setName()
     * @uses Discount::setOpenDrawer()
     * @uses Discount::setPrintOrder()
     * @uses Discount::setPrintedName()
     * @uses Discount::setRate()
     * @uses Discount::setSaturday()
     * @uses Discount::setStartDate()
     * @uses Discount::setStartTime()
     * @uses Discount::setSunday()
     * @uses Discount::setThursday()
     * @uses Discount::setTuesday()
     * @uses Discount::setType()
     * @uses Discount::setUseDateRangeFilter()
     * @uses Discount::setUseDayFilter()
     * @uses Discount::setUseItemFilter()
     * @uses Discount::setUseItemGroupFilter()
     * @uses Discount::setUseTimeRangeFilter()
     * @uses Discount::setWednesday()
     * @param bool $active
     * @param bool $allowLaterDiscounts
     * @param bool $allowPriorDiscounts
     * @param float $amount
     * @param bool $discountedItemsEligible
     * @param \ArrayType\ArrayOfint $eligibleItemGroupIds
     * @param int $eligibleItemId
     * @param string $endDate
     * @param string $endTime
     * @param bool $enforceMaximumAmount
     * @param bool $enforceMaximumItems
     * @param bool $enforceMaximumPerOrder
     * @param bool $excludeItemsFromProductMix
     * @param bool $friday
     * @param string $granularity
     * @param int $id
     * @param bool $isEmployeeDiscount
     * @param bool $isLoyaltyDiscount
     * @param bool $managerNeeded
     * @param float $maximumAmount
     * @param int $maximumItems
     * @param int $maximumPerOrder
     * @param bool $monday
     * @param bool $mustEnterAmount
     * @param bool $mustEnterName
     * @param bool $mustEnterPercent
     * @param string $name
     * @param bool $openDrawer
     * @param bool $printOrder
     * @param string $printedName
     * @param float $rate
     * @param bool $saturday
     * @param string $startDate
     * @param string $startTime
     * @param bool $sunday
     * @param bool $thursday
     * @param bool $tuesday
     * @param string $type
     * @param bool $useDateRangeFilter
     * @param bool $useDayFilter
     * @param bool $useItemFilter
     * @param bool $useItemGroupFilter
     * @param bool $useTimeRangeFilter
     * @param bool $wednesday
     */
    public function __construct($active = null, $allowLaterDiscounts = null, $allowPriorDiscounts = null, $amount = null, $discountedItemsEligible = null, \ArrayType\ArrayOfint $eligibleItemGroupIds = null, $eligibleItemId = null, $endDate = null, $endTime = null, $enforceMaximumAmount = null, $enforceMaximumItems = null, $enforceMaximumPerOrder = null, $excludeItemsFromProductMix = null, $friday = null, $granularity = null, $id = null, $isEmployeeDiscount = null, $isLoyaltyDiscount = null, $managerNeeded = null, $maximumAmount = null, $maximumItems = null, $maximumPerOrder = null, $monday = null, $mustEnterAmount = null, $mustEnterName = null, $mustEnterPercent = null, $name = null, $openDrawer = null, $printOrder = null, $printedName = null, $rate = null, $saturday = null, $startDate = null, $startTime = null, $sunday = null, $thursday = null, $tuesday = null, $type = null, $useDateRangeFilter = null, $useDayFilter = null, $useItemFilter = null, $useItemGroupFilter = null, $useTimeRangeFilter = null, $wednesday = null)
    {
        $this
            ->setActive($active)
            ->setAllowLaterDiscounts($allowLaterDiscounts)
            ->setAllowPriorDiscounts($allowPriorDiscounts)
            ->setAmount($amount)
            ->setDiscountedItemsEligible($discountedItemsEligible)
            ->setEligibleItemGroupIds($eligibleItemGroupIds)
            ->setEligibleItemId($eligibleItemId)
            ->setEndDate($endDate)
            ->setEndTime($endTime)
            ->setEnforceMaximumAmount($enforceMaximumAmount)
            ->setEnforceMaximumItems($enforceMaximumItems)
            ->setEnforceMaximumPerOrder($enforceMaximumPerOrder)
            ->setExcludeItemsFromProductMix($excludeItemsFromProductMix)
            ->setFriday($friday)
            ->setGranularity($granularity)
            ->setId($id)
            ->setIsEmployeeDiscount($isEmployeeDiscount)
            ->setIsLoyaltyDiscount($isLoyaltyDiscount)
            ->setManagerNeeded($managerNeeded)
            ->setMaximumAmount($maximumAmount)
            ->setMaximumItems($maximumItems)
            ->setMaximumPerOrder($maximumPerOrder)
            ->setMonday($monday)
            ->setMustEnterAmount($mustEnterAmount)
            ->setMustEnterName($mustEnterName)
            ->setMustEnterPercent($mustEnterPercent)
            ->setName($name)
            ->setOpenDrawer($openDrawer)
            ->setPrintOrder($printOrder)
            ->setPrintedName($printedName)
            ->setRate($rate)
            ->setSaturday($saturday)
            ->setStartDate($startDate)
            ->setStartTime($startTime)
            ->setSunday($sunday)
            ->setThursday($thursday)
            ->setTuesday($tuesday)
            ->setType($type)
            ->setUseDateRangeFilter($useDateRangeFilter)
            ->setUseDayFilter($useDayFilter)
            ->setUseItemFilter($useItemFilter)
            ->setUseItemGroupFilter($useItemGroupFilter)
            ->setUseTimeRangeFilter($useTimeRangeFilter)
            ->setWednesday($wednesday);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\Discount
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AllowLaterDiscounts value
     * @return bool|null
     */
    public function getAllowLaterDiscounts()
    {
        return $this->AllowLaterDiscounts;
    }
    /**
     * Set AllowLaterDiscounts value
     * @param bool $allowLaterDiscounts
     * @return \StructType\Discount
     */
    public function setAllowLaterDiscounts($allowLaterDiscounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowLaterDiscounts) && !is_bool($allowLaterDiscounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowLaterDiscounts)), __LINE__);
        }
        $this->AllowLaterDiscounts = $allowLaterDiscounts;
        return $this;
    }
    /**
     * Get AllowPriorDiscounts value
     * @return bool|null
     */
    public function getAllowPriorDiscounts()
    {
        return $this->AllowPriorDiscounts;
    }
    /**
     * Set AllowPriorDiscounts value
     * @param bool $allowPriorDiscounts
     * @return \StructType\Discount
     */
    public function setAllowPriorDiscounts($allowPriorDiscounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowPriorDiscounts) && !is_bool($allowPriorDiscounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowPriorDiscounts)), __LINE__);
        }
        $this->AllowPriorDiscounts = $allowPriorDiscounts;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\Discount
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get DiscountedItemsEligible value
     * @return bool|null
     */
    public function getDiscountedItemsEligible()
    {
        return $this->DiscountedItemsEligible;
    }
    /**
     * Set DiscountedItemsEligible value
     * @param bool $discountedItemsEligible
     * @return \StructType\Discount
     */
    public function setDiscountedItemsEligible($discountedItemsEligible = null)
    {
        // validation for constraint: boolean
        if (!is_null($discountedItemsEligible) && !is_bool($discountedItemsEligible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($discountedItemsEligible)), __LINE__);
        }
        $this->DiscountedItemsEligible = $discountedItemsEligible;
        return $this;
    }
    /**
     * Get EligibleItemGroupIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfint|null
     */
    public function getEligibleItemGroupIds()
    {
        return isset($this->EligibleItemGroupIds) ? $this->EligibleItemGroupIds : null;
    }
    /**
     * Set EligibleItemGroupIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfint $eligibleItemGroupIds
     * @return \StructType\Discount
     */
    public function setEligibleItemGroupIds(\ArrayType\ArrayOfint $eligibleItemGroupIds = null)
    {
        if (is_null($eligibleItemGroupIds) || (is_array($eligibleItemGroupIds) && empty($eligibleItemGroupIds))) {
            unset($this->EligibleItemGroupIds);
        } else {
            $this->EligibleItemGroupIds = $eligibleItemGroupIds;
        }
        return $this;
    }
    /**
     * Get EligibleItemId value
     * @return int|null
     */
    public function getEligibleItemId()
    {
        return $this->EligibleItemId;
    }
    /**
     * Set EligibleItemId value
     * @param int $eligibleItemId
     * @return \StructType\Discount
     */
    public function setEligibleItemId($eligibleItemId = null)
    {
        // validation for constraint: int
        if (!is_null($eligibleItemId) && !is_numeric($eligibleItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($eligibleItemId)), __LINE__);
        }
        $this->EligibleItemId = $eligibleItemId;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \StructType\Discount
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\Discount
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endTime)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
    /**
     * Get EnforceMaximumAmount value
     * @return bool|null
     */
    public function getEnforceMaximumAmount()
    {
        return $this->EnforceMaximumAmount;
    }
    /**
     * Set EnforceMaximumAmount value
     * @param bool $enforceMaximumAmount
     * @return \StructType\Discount
     */
    public function setEnforceMaximumAmount($enforceMaximumAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceMaximumAmount) && !is_bool($enforceMaximumAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enforceMaximumAmount)), __LINE__);
        }
        $this->EnforceMaximumAmount = $enforceMaximumAmount;
        return $this;
    }
    /**
     * Get EnforceMaximumItems value
     * @return bool|null
     */
    public function getEnforceMaximumItems()
    {
        return $this->EnforceMaximumItems;
    }
    /**
     * Set EnforceMaximumItems value
     * @param bool $enforceMaximumItems
     * @return \StructType\Discount
     */
    public function setEnforceMaximumItems($enforceMaximumItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceMaximumItems) && !is_bool($enforceMaximumItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enforceMaximumItems)), __LINE__);
        }
        $this->EnforceMaximumItems = $enforceMaximumItems;
        return $this;
    }
    /**
     * Get EnforceMaximumPerOrder value
     * @return bool|null
     */
    public function getEnforceMaximumPerOrder()
    {
        return $this->EnforceMaximumPerOrder;
    }
    /**
     * Set EnforceMaximumPerOrder value
     * @param bool $enforceMaximumPerOrder
     * @return \StructType\Discount
     */
    public function setEnforceMaximumPerOrder($enforceMaximumPerOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceMaximumPerOrder) && !is_bool($enforceMaximumPerOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($enforceMaximumPerOrder)), __LINE__);
        }
        $this->EnforceMaximumPerOrder = $enforceMaximumPerOrder;
        return $this;
    }
    /**
     * Get ExcludeItemsFromProductMix value
     * @return bool|null
     */
    public function getExcludeItemsFromProductMix()
    {
        return $this->ExcludeItemsFromProductMix;
    }
    /**
     * Set ExcludeItemsFromProductMix value
     * @param bool $excludeItemsFromProductMix
     * @return \StructType\Discount
     */
    public function setExcludeItemsFromProductMix($excludeItemsFromProductMix = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeItemsFromProductMix) && !is_bool($excludeItemsFromProductMix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excludeItemsFromProductMix)), __LINE__);
        }
        $this->ExcludeItemsFromProductMix = $excludeItemsFromProductMix;
        return $this;
    }
    /**
     * Get Friday value
     * @return bool|null
     */
    public function getFriday()
    {
        return $this->Friday;
    }
    /**
     * Set Friday value
     * @param bool $friday
     * @return \StructType\Discount
     */
    public function setFriday($friday = null)
    {
        // validation for constraint: boolean
        if (!is_null($friday) && !is_bool($friday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($friday)), __LINE__);
        }
        $this->Friday = $friday;
        return $this;
    }
    /**
     * Get Granularity value
     * @return string|null
     */
    public function getGranularity()
    {
        return $this->Granularity;
    }
    /**
     * Set Granularity value
     * @uses \EnumType\DiscountGranularity::valueIsValid()
     * @uses \EnumType\DiscountGranularity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $granularity
     * @return \StructType\Discount
     */
    public function setGranularity($granularity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DiscountGranularity::valueIsValid($granularity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $granularity, implode(', ', \EnumType\DiscountGranularity::getValidValues())), __LINE__);
        }
        $this->Granularity = $granularity;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Discount
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsEmployeeDiscount value
     * @return bool|null
     */
    public function getIsEmployeeDiscount()
    {
        return $this->IsEmployeeDiscount;
    }
    /**
     * Set IsEmployeeDiscount value
     * @param bool $isEmployeeDiscount
     * @return \StructType\Discount
     */
    public function setIsEmployeeDiscount($isEmployeeDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEmployeeDiscount) && !is_bool($isEmployeeDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isEmployeeDiscount)), __LINE__);
        }
        $this->IsEmployeeDiscount = $isEmployeeDiscount;
        return $this;
    }
    /**
     * Get IsLoyaltyDiscount value
     * @return bool|null
     */
    public function getIsLoyaltyDiscount()
    {
        return $this->IsLoyaltyDiscount;
    }
    /**
     * Set IsLoyaltyDiscount value
     * @param bool $isLoyaltyDiscount
     * @return \StructType\Discount
     */
    public function setIsLoyaltyDiscount($isLoyaltyDiscount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLoyaltyDiscount) && !is_bool($isLoyaltyDiscount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isLoyaltyDiscount)), __LINE__);
        }
        $this->IsLoyaltyDiscount = $isLoyaltyDiscount;
        return $this;
    }
    /**
     * Get ManagerNeeded value
     * @return bool|null
     */
    public function getManagerNeeded()
    {
        return $this->ManagerNeeded;
    }
    /**
     * Set ManagerNeeded value
     * @param bool $managerNeeded
     * @return \StructType\Discount
     */
    public function setManagerNeeded($managerNeeded = null)
    {
        // validation for constraint: boolean
        if (!is_null($managerNeeded) && !is_bool($managerNeeded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($managerNeeded)), __LINE__);
        }
        $this->ManagerNeeded = $managerNeeded;
        return $this;
    }
    /**
     * Get MaximumAmount value
     * @return float|null
     */
    public function getMaximumAmount()
    {
        return $this->MaximumAmount;
    }
    /**
     * Set MaximumAmount value
     * @param float $maximumAmount
     * @return \StructType\Discount
     */
    public function setMaximumAmount($maximumAmount = null)
    {
        $this->MaximumAmount = $maximumAmount;
        return $this;
    }
    /**
     * Get MaximumItems value
     * @return int|null
     */
    public function getMaximumItems()
    {
        return $this->MaximumItems;
    }
    /**
     * Set MaximumItems value
     * @param int $maximumItems
     * @return \StructType\Discount
     */
    public function setMaximumItems($maximumItems = null)
    {
        // validation for constraint: int
        if (!is_null($maximumItems) && !is_numeric($maximumItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumItems)), __LINE__);
        }
        $this->MaximumItems = $maximumItems;
        return $this;
    }
    /**
     * Get MaximumPerOrder value
     * @return int|null
     */
    public function getMaximumPerOrder()
    {
        return $this->MaximumPerOrder;
    }
    /**
     * Set MaximumPerOrder value
     * @param int $maximumPerOrder
     * @return \StructType\Discount
     */
    public function setMaximumPerOrder($maximumPerOrder = null)
    {
        // validation for constraint: int
        if (!is_null($maximumPerOrder) && !is_numeric($maximumPerOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maximumPerOrder)), __LINE__);
        }
        $this->MaximumPerOrder = $maximumPerOrder;
        return $this;
    }
    /**
     * Get Monday value
     * @return bool|null
     */
    public function getMonday()
    {
        return $this->Monday;
    }
    /**
     * Set Monday value
     * @param bool $monday
     * @return \StructType\Discount
     */
    public function setMonday($monday = null)
    {
        // validation for constraint: boolean
        if (!is_null($monday) && !is_bool($monday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($monday)), __LINE__);
        }
        $this->Monday = $monday;
        return $this;
    }
    /**
     * Get MustEnterAmount value
     * @return bool|null
     */
    public function getMustEnterAmount()
    {
        return $this->MustEnterAmount;
    }
    /**
     * Set MustEnterAmount value
     * @param bool $mustEnterAmount
     * @return \StructType\Discount
     */
    public function setMustEnterAmount($mustEnterAmount = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustEnterAmount) && !is_bool($mustEnterAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mustEnterAmount)), __LINE__);
        }
        $this->MustEnterAmount = $mustEnterAmount;
        return $this;
    }
    /**
     * Get MustEnterName value
     * @return bool|null
     */
    public function getMustEnterName()
    {
        return $this->MustEnterName;
    }
    /**
     * Set MustEnterName value
     * @param bool $mustEnterName
     * @return \StructType\Discount
     */
    public function setMustEnterName($mustEnterName = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustEnterName) && !is_bool($mustEnterName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mustEnterName)), __LINE__);
        }
        $this->MustEnterName = $mustEnterName;
        return $this;
    }
    /**
     * Get MustEnterPercent value
     * @return bool|null
     */
    public function getMustEnterPercent()
    {
        return $this->MustEnterPercent;
    }
    /**
     * Set MustEnterPercent value
     * @param bool $mustEnterPercent
     * @return \StructType\Discount
     */
    public function setMustEnterPercent($mustEnterPercent = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustEnterPercent) && !is_bool($mustEnterPercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mustEnterPercent)), __LINE__);
        }
        $this->MustEnterPercent = $mustEnterPercent;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Discount
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OpenDrawer value
     * @return bool|null
     */
    public function getOpenDrawer()
    {
        return $this->OpenDrawer;
    }
    /**
     * Set OpenDrawer value
     * @param bool $openDrawer
     * @return \StructType\Discount
     */
    public function setOpenDrawer($openDrawer = null)
    {
        // validation for constraint: boolean
        if (!is_null($openDrawer) && !is_bool($openDrawer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($openDrawer)), __LINE__);
        }
        $this->OpenDrawer = $openDrawer;
        return $this;
    }
    /**
     * Get PrintOrder value
     * @return bool|null
     */
    public function getPrintOrder()
    {
        return $this->PrintOrder;
    }
    /**
     * Set PrintOrder value
     * @param bool $printOrder
     * @return \StructType\Discount
     */
    public function setPrintOrder($printOrder = null)
    {
        // validation for constraint: boolean
        if (!is_null($printOrder) && !is_bool($printOrder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($printOrder)), __LINE__);
        }
        $this->PrintOrder = $printOrder;
        return $this;
    }
    /**
     * Get PrintedName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedName()
    {
        return isset($this->PrintedName) ? $this->PrintedName : null;
    }
    /**
     * Set PrintedName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedName
     * @return \StructType\Discount
     */
    public function setPrintedName($printedName = null)
    {
        // validation for constraint: string
        if (!is_null($printedName) && !is_string($printedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($printedName)), __LINE__);
        }
        if (is_null($printedName) || (is_array($printedName) && empty($printedName))) {
            unset($this->PrintedName);
        } else {
            $this->PrintedName = $printedName;
        }
        return $this;
    }
    /**
     * Get Rate value
     * @return float|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\Discount
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get Saturday value
     * @return bool|null
     */
    public function getSaturday()
    {
        return $this->Saturday;
    }
    /**
     * Set Saturday value
     * @param bool $saturday
     * @return \StructType\Discount
     */
    public function setSaturday($saturday = null)
    {
        // validation for constraint: boolean
        if (!is_null($saturday) && !is_bool($saturday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($saturday)), __LINE__);
        }
        $this->Saturday = $saturday;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\Discount
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\Discount
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startTime)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get Sunday value
     * @return bool|null
     */
    public function getSunday()
    {
        return $this->Sunday;
    }
    /**
     * Set Sunday value
     * @param bool $sunday
     * @return \StructType\Discount
     */
    public function setSunday($sunday = null)
    {
        // validation for constraint: boolean
        if (!is_null($sunday) && !is_bool($sunday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sunday)), __LINE__);
        }
        $this->Sunday = $sunday;
        return $this;
    }
    /**
     * Get Thursday value
     * @return bool|null
     */
    public function getThursday()
    {
        return $this->Thursday;
    }
    /**
     * Set Thursday value
     * @param bool $thursday
     * @return \StructType\Discount
     */
    public function setThursday($thursday = null)
    {
        // validation for constraint: boolean
        if (!is_null($thursday) && !is_bool($thursday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($thursday)), __LINE__);
        }
        $this->Thursday = $thursday;
        return $this;
    }
    /**
     * Get Tuesday value
     * @return bool|null
     */
    public function getTuesday()
    {
        return $this->Tuesday;
    }
    /**
     * Set Tuesday value
     * @param bool $tuesday
     * @return \StructType\Discount
     */
    public function setTuesday($tuesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($tuesday) && !is_bool($tuesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($tuesday)), __LINE__);
        }
        $this->Tuesday = $tuesday;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\DiscountType::valueIsValid()
     * @uses \EnumType\DiscountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\Discount
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DiscountType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\DiscountType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get UseDateRangeFilter value
     * @return bool|null
     */
    public function getUseDateRangeFilter()
    {
        return $this->UseDateRangeFilter;
    }
    /**
     * Set UseDateRangeFilter value
     * @param bool $useDateRangeFilter
     * @return \StructType\Discount
     */
    public function setUseDateRangeFilter($useDateRangeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($useDateRangeFilter) && !is_bool($useDateRangeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useDateRangeFilter)), __LINE__);
        }
        $this->UseDateRangeFilter = $useDateRangeFilter;
        return $this;
    }
    /**
     * Get UseDayFilter value
     * @return bool|null
     */
    public function getUseDayFilter()
    {
        return $this->UseDayFilter;
    }
    /**
     * Set UseDayFilter value
     * @param bool $useDayFilter
     * @return \StructType\Discount
     */
    public function setUseDayFilter($useDayFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($useDayFilter) && !is_bool($useDayFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useDayFilter)), __LINE__);
        }
        $this->UseDayFilter = $useDayFilter;
        return $this;
    }
    /**
     * Get UseItemFilter value
     * @return bool|null
     */
    public function getUseItemFilter()
    {
        return $this->UseItemFilter;
    }
    /**
     * Set UseItemFilter value
     * @param bool $useItemFilter
     * @return \StructType\Discount
     */
    public function setUseItemFilter($useItemFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($useItemFilter) && !is_bool($useItemFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useItemFilter)), __LINE__);
        }
        $this->UseItemFilter = $useItemFilter;
        return $this;
    }
    /**
     * Get UseItemGroupFilter value
     * @return bool|null
     */
    public function getUseItemGroupFilter()
    {
        return $this->UseItemGroupFilter;
    }
    /**
     * Set UseItemGroupFilter value
     * @param bool $useItemGroupFilter
     * @return \StructType\Discount
     */
    public function setUseItemGroupFilter($useItemGroupFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($useItemGroupFilter) && !is_bool($useItemGroupFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useItemGroupFilter)), __LINE__);
        }
        $this->UseItemGroupFilter = $useItemGroupFilter;
        return $this;
    }
    /**
     * Get UseTimeRangeFilter value
     * @return bool|null
     */
    public function getUseTimeRangeFilter()
    {
        return $this->UseTimeRangeFilter;
    }
    /**
     * Set UseTimeRangeFilter value
     * @param bool $useTimeRangeFilter
     * @return \StructType\Discount
     */
    public function setUseTimeRangeFilter($useTimeRangeFilter = null)
    {
        // validation for constraint: boolean
        if (!is_null($useTimeRangeFilter) && !is_bool($useTimeRangeFilter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useTimeRangeFilter)), __LINE__);
        }
        $this->UseTimeRangeFilter = $useTimeRangeFilter;
        return $this;
    }
    /**
     * Get Wednesday value
     * @return bool|null
     */
    public function getWednesday()
    {
        return $this->Wednesday;
    }
    /**
     * Set Wednesday value
     * @param bool $wednesday
     * @return \StructType\Discount
     */
    public function setWednesday($wednesday = null)
    {
        // validation for constraint: boolean
        if (!is_null($wednesday) && !is_bool($wednesday)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($wednesday)), __LINE__);
        }
        $this->Wednesday = $wednesday;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Discount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
