<?php

namespace EnumType;

/**
 * This class stands for TimeZone EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TimeZone
 * @subpackage Enumerations
 */
class TimeZone
{
    /**
     * Constant for value 'Hawaii'
     * @return string 'Hawaii'
     */
    const VALUE_HAWAII = 'Hawaii';
    /**
     * Constant for value 'Alaska'
     * @return string 'Alaska'
     */
    const VALUE_ALASKA = 'Alaska';
    /**
     * Constant for value 'Pacific'
     * @return string 'Pacific'
     */
    const VALUE_PACIFIC = 'Pacific';
    /**
     * Constant for value 'Arizona'
     * @return string 'Arizona'
     */
    const VALUE_ARIZONA = 'Arizona';
    /**
     * Constant for value 'Mountain'
     * @return string 'Mountain'
     */
    const VALUE_MOUNTAIN = 'Mountain';
    /**
     * Constant for value 'Central'
     * @return string 'Central'
     */
    const VALUE_CENTRAL = 'Central';
    /**
     * Constant for value 'Eastern'
     * @return string 'Eastern'
     */
    const VALUE_EASTERN = 'Eastern';
    /**
     * Constant for value 'GeorgetownLaPazManausSanJuan'
     * @return string 'GeorgetownLaPazManausSanJuan'
     */
    const VALUE_GEORGETOWN_LA_PAZ_MANAUS_SAN_JUAN = 'GeorgetownLaPazManausSanJuan';
    /**
     * Constant for value 'CanadaCentral'
     * @return string 'CanadaCentral'
     */
    const VALUE_CANADA_CENTRAL = 'CanadaCentral';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HAWAII
     * @uses self::VALUE_ALASKA
     * @uses self::VALUE_PACIFIC
     * @uses self::VALUE_ARIZONA
     * @uses self::VALUE_MOUNTAIN
     * @uses self::VALUE_CENTRAL
     * @uses self::VALUE_EASTERN
     * @uses self::VALUE_GEORGETOWN_LA_PAZ_MANAUS_SAN_JUAN
     * @uses self::VALUE_CANADA_CENTRAL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HAWAII,
            self::VALUE_ALASKA,
            self::VALUE_PACIFIC,
            self::VALUE_ARIZONA,
            self::VALUE_MOUNTAIN,
            self::VALUE_CENTRAL,
            self::VALUE_EASTERN,
            self::VALUE_GEORGETOWN_LA_PAZ_MANAUS_SAN_JUAN,
            self::VALUE_CANADA_CENTRAL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
