<?php

namespace EnumType;

/**
 * This class stands for PromotionType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PromotionType
 * @subpackage Enumerations
 */
class PromotionType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Bogo'
     * @return string 'Bogo'
     */
    const VALUE_BOGO = 'Bogo';
    /**
     * Constant for value 'OrderReduction'
     * @return string 'OrderReduction'
     */
    const VALUE_ORDER_REDUCTION = 'OrderReduction';
    /**
     * Constant for value 'Coupon'
     * @return string 'Coupon'
     */
    const VALUE_COUPON = 'Coupon';
    /**
     * Constant for value 'GiftCard'
     * @return string 'GiftCard'
     */
    const VALUE_GIFT_CARD = 'GiftCard';
    /**
     * Constant for value 'Combo'
     * @return string 'Combo'
     */
    const VALUE_COMBO = 'Combo';
    /**
     * Constant for value 'Max'
     * @return string 'Max'
     */
    const VALUE_MAX = 'Max';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_BOGO
     * @uses self::VALUE_ORDER_REDUCTION
     * @uses self::VALUE_COUPON
     * @uses self::VALUE_GIFT_CARD
     * @uses self::VALUE_COMBO
     * @uses self::VALUE_MAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_BOGO,
            self::VALUE_ORDER_REDUCTION,
            self::VALUE_COUPON,
            self::VALUE_GIFT_CARD,
            self::VALUE_COMBO,
            self::VALUE_MAX,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
