<?php

namespace EnumType;

/**
 * This class stands for MaritalStatus EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MaritalStatus
 * @subpackage Enumerations
 */
class MaritalStatus
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'Single'
     * @return string 'Single'
     */
    const VALUE_SINGLE = 'Single';
    /**
     * Constant for value 'Married'
     * @return string 'Married'
     */
    const VALUE_MARRIED = 'Married';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_SINGLE
     * @uses self::VALUE_MARRIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_SINGLE,
            self::VALUE_MARRIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
