<?php

namespace EnumType;

/**
 * This class stands for ItemType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ItemType
 * @subpackage Enumerations
 */
class ItemType
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Pizza'
     * @return string 'Pizza'
     */
    const VALUE_PIZZA = 'Pizza';
    /**
     * Constant for value 'Chicken'
     * @return string 'Chicken'
     */
    const VALUE_CHICKEN = 'Chicken';
    /**
     * Constant for value 'GiftCard'
     * @return string 'GiftCard'
     */
    const VALUE_GIFT_CARD = 'GiftCard';
    /**
     * Constant for value 'Composite'
     * @return string 'Composite'
     */
    const VALUE_COMPOSITE = 'Composite';
    /**
     * Constant for value 'LoyaltyItem'
     * @return string 'LoyaltyItem'
     */
    const VALUE_LOYALTY_ITEM = 'LoyaltyItem';
    /**
     * Constant for value 'Prepaid'
     * @return string 'Prepaid'
     */
    const VALUE_PREPAID = 'Prepaid';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_PIZZA
     * @uses self::VALUE_CHICKEN
     * @uses self::VALUE_GIFT_CARD
     * @uses self::VALUE_COMPOSITE
     * @uses self::VALUE_LOYALTY_ITEM
     * @uses self::VALUE_PREPAID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_PIZZA,
            self::VALUE_CHICKEN,
            self::VALUE_GIFT_CARD,
            self::VALUE_COMPOSITE,
            self::VALUE_LOYALTY_ITEM,
            self::VALUE_PREPAID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
