<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRegister ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfRegister
 * @subpackage Arrays
 */
class ArrayOfRegister extends AbstractStructArrayBase
{
    /**
     * The Register
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Register[]
     */
    public $Register;
    /**
     * Constructor method for ArrayOfRegister
     * @uses ArrayOfRegister::setRegister()
     * @param \StructType\Register[] $register
     */
    public function __construct(array $register = array())
    {
        $this
            ->setRegister($register);
    }
    /**
     * Get Register value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Register[]|null
     */
    public function getRegister()
    {
        return isset($this->Register) ? $this->Register : null;
    }
    /**
     * Set Register value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Register[] $register
     * @return \ArrayType\ArrayOfRegister
     */
    public function setRegister(array $register = array())
    {
        foreach ($register as $arrayOfRegisterRegisterItem) {
            // validation for constraint: itemType
            if (!$arrayOfRegisterRegisterItem instanceof \StructType\Register) {
                throw new \InvalidArgumentException(sprintf('The Register property can only contain items of \StructType\Register, "%s" given', is_object($arrayOfRegisterRegisterItem) ? get_class($arrayOfRegisterRegisterItem) : gettype($arrayOfRegisterRegisterItem)), __LINE__);
            }
        }
        if (is_null($register) || (is_array($register) && empty($register))) {
            unset($this->Register);
        } else {
            $this->Register = $register;
        }
        return $this;
    }
    /**
     * Add item to Register value
     * @throws \InvalidArgumentException
     * @param \StructType\Register $item
     * @return \ArrayType\ArrayOfRegister
     */
    public function addToRegister(\StructType\Register $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Register) {
            throw new \InvalidArgumentException(sprintf('The Register property can only contain items of \StructType\Register, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Register[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Register|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Register|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Register|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Register|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Register|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Register
     */
    public function getAttributeName()
    {
        return 'Register';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfRegister
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
