<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJob ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfJob
 * @subpackage Arrays
 */
class ArrayOfJob extends AbstractStructArrayBase
{
    /**
     * The Job
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Job[]
     */
    public $Job;
    /**
     * Constructor method for ArrayOfJob
     * @uses ArrayOfJob::setJob()
     * @param \StructType\Job[] $job
     */
    public function __construct(array $job = array())
    {
        $this
            ->setJob($job);
    }
    /**
     * Get Job value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Job[]|null
     */
    public function getJob()
    {
        return isset($this->Job) ? $this->Job : null;
    }
    /**
     * Set Job value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Job[] $job
     * @return \ArrayType\ArrayOfJob
     */
    public function setJob(array $job = array())
    {
        foreach ($job as $arrayOfJobJobItem) {
            // validation for constraint: itemType
            if (!$arrayOfJobJobItem instanceof \StructType\Job) {
                throw new \InvalidArgumentException(sprintf('The Job property can only contain items of \StructType\Job, "%s" given', is_object($arrayOfJobJobItem) ? get_class($arrayOfJobJobItem) : gettype($arrayOfJobJobItem)), __LINE__);
            }
        }
        if (is_null($job) || (is_array($job) && empty($job))) {
            unset($this->Job);
        } else {
            $this->Job = $job;
        }
        return $this;
    }
    /**
     * Add item to Job value
     * @throws \InvalidArgumentException
     * @param \StructType\Job $item
     * @return \ArrayType\ArrayOfJob
     */
    public function addToJob(\StructType\Job $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Job) {
            throw new \InvalidArgumentException(sprintf('The Job property can only contain items of \StructType\Job, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Job[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Job|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Job|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Job|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Job|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Job|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Job
     */
    public function getAttributeName()
    {
        return 'Job';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJob
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
