<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModifierCode StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ModifierCode
 * @subpackage Structs
 */
class ModifierCode extends SettingsObject
{
    /**
     * The Abbreviation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Abbreviation;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The AppliesTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AppliesTo;
    /**
     * The IsSystem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSystem;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for ModifierCode
     * @uses ModifierCode::setAbbreviation()
     * @uses ModifierCode::setActive()
     * @uses ModifierCode::setAppliesTo()
     * @uses ModifierCode::setIsSystem()
     * @uses ModifierCode::setType()
     * @param string $abbreviation
     * @param bool $active
     * @param string $appliesTo
     * @param bool $isSystem
     * @param string $type
     */
    public function __construct($abbreviation = null, $active = null, $appliesTo = null, $isSystem = null, $type = null)
    {
        $this
            ->setAbbreviation($abbreviation)
            ->setActive($active)
            ->setAppliesTo($appliesTo)
            ->setIsSystem($isSystem)
            ->setType($type);
    }
    /**
     * Get Abbreviation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAbbreviation()
    {
        return isset($this->Abbreviation) ? $this->Abbreviation : null;
    }
    /**
     * Set Abbreviation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $abbreviation
     * @return \StructType\ModifierCode
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviation)), __LINE__);
        }
        if (is_null($abbreviation) || (is_array($abbreviation) && empty($abbreviation))) {
            unset($this->Abbreviation);
        } else {
            $this->Abbreviation = $abbreviation;
        }
        return $this;
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\ModifierCode
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get AppliesTo value
     * @return string|null
     */
    public function getAppliesTo()
    {
        return $this->AppliesTo;
    }
    /**
     * Set AppliesTo value
     * @uses \EnumType\ModCodeIngredientType::valueIsValid()
     * @uses \EnumType\ModCodeIngredientType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $appliesTo
     * @return \StructType\ModifierCode
     */
    public function setAppliesTo($appliesTo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModCodeIngredientType::valueIsValid($appliesTo)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $appliesTo, implode(', ', \EnumType\ModCodeIngredientType::getValidValues())), __LINE__);
        }
        $this->AppliesTo = $appliesTo;
        return $this;
    }
    /**
     * Get IsSystem value
     * @return bool|null
     */
    public function getIsSystem()
    {
        return $this->IsSystem;
    }
    /**
     * Set IsSystem value
     * @param bool $isSystem
     * @return \StructType\ModifierCode
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSystem)), __LINE__);
        }
        $this->IsSystem = $isSystem;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\ModCodeType::valueIsValid()
     * @uses \EnumType\ModCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\ModifierCode
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ModCodeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\ModCodeType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModifierCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
