<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CashDrawer StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CashDrawer
 * @subpackage Structs
 */
class CashDrawer extends AbstractStructBase
{
    /**
     * The DefaultBank
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DefaultBank;
    /**
     * The DrawerNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DrawerNumber;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The IsCompulsory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsCompulsory;
    /**
     * The IsPublic
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsPublic;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The TerminalId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TerminalId;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Type;
    /**
     * Constructor method for CashDrawer
     * @uses CashDrawer::setDefaultBank()
     * @uses CashDrawer::setDrawerNumber()
     * @uses CashDrawer::setId()
     * @uses CashDrawer::setIsCompulsory()
     * @uses CashDrawer::setIsPublic()
     * @uses CashDrawer::setName()
     * @uses CashDrawer::setTerminalId()
     * @uses CashDrawer::setType()
     * @param float $defaultBank
     * @param string $drawerNumber
     * @param int $id
     * @param bool $isCompulsory
     * @param bool $isPublic
     * @param string $name
     * @param int $terminalId
     * @param int $type
     */
    public function __construct($defaultBank = null, $drawerNumber = null, $id = null, $isCompulsory = null, $isPublic = null, $name = null, $terminalId = null, $type = null)
    {
        $this
            ->setDefaultBank($defaultBank)
            ->setDrawerNumber($drawerNumber)
            ->setId($id)
            ->setIsCompulsory($isCompulsory)
            ->setIsPublic($isPublic)
            ->setName($name)
            ->setTerminalId($terminalId)
            ->setType($type);
    }
    /**
     * Get DefaultBank value
     * @return float|null
     */
    public function getDefaultBank()
    {
        return $this->DefaultBank;
    }
    /**
     * Set DefaultBank value
     * @param float $defaultBank
     * @return \StructType\CashDrawer
     */
    public function setDefaultBank($defaultBank = null)
    {
        $this->DefaultBank = $defaultBank;
        return $this;
    }
    /**
     * Get DrawerNumber value
     * @return string|null
     */
    public function getDrawerNumber()
    {
        return $this->DrawerNumber;
    }
    /**
     * Set DrawerNumber value
     * @param string $drawerNumber
     * @return \StructType\CashDrawer
     */
    public function setDrawerNumber($drawerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($drawerNumber) && !is_string($drawerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($drawerNumber)), __LINE__);
        }
        $this->DrawerNumber = $drawerNumber;
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\CashDrawer
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !is_numeric($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IsCompulsory value
     * @return bool|null
     */
    public function getIsCompulsory()
    {
        return $this->IsCompulsory;
    }
    /**
     * Set IsCompulsory value
     * @param bool $isCompulsory
     * @return \StructType\CashDrawer
     */
    public function setIsCompulsory($isCompulsory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCompulsory) && !is_bool($isCompulsory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isCompulsory)), __LINE__);
        }
        $this->IsCompulsory = $isCompulsory;
        return $this;
    }
    /**
     * Get IsPublic value
     * @return bool|null
     */
    public function getIsPublic()
    {
        return $this->IsPublic;
    }
    /**
     * Set IsPublic value
     * @param bool $isPublic
     * @return \StructType\CashDrawer
     */
    public function setIsPublic($isPublic = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPublic) && !is_bool($isPublic)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPublic)), __LINE__);
        }
        $this->IsPublic = $isPublic;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\CashDrawer
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get TerminalId value
     * @return int|null
     */
    public function getTerminalId()
    {
        return $this->TerminalId;
    }
    /**
     * Set TerminalId value
     * @param int $terminalId
     * @return \StructType\CashDrawer
     */
    public function setTerminalId($terminalId = null)
    {
        // validation for constraint: int
        if (!is_null($terminalId) && !is_numeric($terminalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($terminalId)), __LINE__);
        }
        $this->TerminalId = $terminalId;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\CashDrawer
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CashDrawer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
