<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCashDrawers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCashDrawers $parameters
     * @return \StructType\GetCashDrawersResponse|bool
     */
    public function GetCashDrawers(\StructType\GetCashDrawers $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCashDrawers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDayParts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDayParts $parameters
     * @return \StructType\GetDayPartsResponse|bool
     */
    public function GetDayParts(\StructType\GetDayParts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDayParts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDestinations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDestinations $parameters
     * @return \StructType\GetDestinationsResponse|bool
     */
    public function GetDestinations(\StructType\GetDestinations $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDestinations($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDiscounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDiscounts $parameters
     * @return \StructType\GetDiscountsResponse|bool
     */
    public function GetDiscounts(\StructType\GetDiscounts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDiscounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetEmployees
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEmployees $parameters
     * @return \StructType\GetEmployeesResponse|bool
     */
    public function GetEmployees(\StructType\GetEmployees $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetEmployees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItemGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItemGroups $parameters
     * @return \StructType\GetItemGroupsResponse|bool
     */
    public function GetItemGroups(\StructType\GetItemGroups $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetItemGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetItems
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetItems $parameters
     * @return \StructType\GetItemsResponse|bool
     */
    public function GetItems(\StructType\GetItems $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetItems($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetJobs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetJobs $parameters
     * @return \StructType\GetJobsResponse|bool
     */
    public function GetJobs(\StructType\GetJobs $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetJobs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoyaltyRewards
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetLoyaltyRewards $parameters
     * @return \StructType\GetLoyaltyRewardsResponse|bool
     */
    public function GetLoyaltyRewards(\StructType\GetLoyaltyRewards $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetLoyaltyRewards($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetModifierCodes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifierCodes $parameters
     * @return \StructType\GetModifierCodesResponse|bool
     */
    public function GetModifierCodes(\StructType\GetModifierCodes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetModifierCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetModifierGroups
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModifierGroups $parameters
     * @return \StructType\GetModifierGroupsResponse|bool
     */
    public function GetModifierGroups(\StructType\GetModifierGroups $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetModifierGroups($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetOptions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetOptions $parameters
     * @return \StructType\GetOptionsResponse|bool
     */
    public function GetOptions(\StructType\GetOptions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetOptions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPettyAccounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPettyAccounts $parameters
     * @return \StructType\GetPettyAccountsResponse|bool
     */
    public function GetPettyAccounts(\StructType\GetPettyAccounts $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPettyAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPromotions
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPromotions $parameters
     * @return \StructType\GetPromotionsResponse|bool
     */
    public function GetPromotions(\StructType\GetPromotions $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPromotions($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRegisters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRegisters $parameters
     * @return \StructType\GetRegistersResponse|bool
     */
    public function GetRegisters(\StructType\GetRegisters $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRegisters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetRevenueCenters
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetRevenueCenters $parameters
     * @return \StructType\GetRevenueCentersResponse|bool
     */
    public function GetRevenueCenters(\StructType\GetRevenueCenters $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetRevenueCenters($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSections
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSections $parameters
     * @return \StructType\GetSectionsResponse|bool
     */
    public function GetSections(\StructType\GetSections $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSections($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSurcharges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSurcharges $parameters
     * @return \StructType\GetSurchargesResponse|bool
     */
    public function GetSurcharges(\StructType\GetSurcharges $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetSurcharges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTaxes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTaxes $parameters
     * @return \StructType\GetTaxesResponse|bool
     */
    public function GetTaxes(\StructType\GetTaxes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTaxes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTenders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTenders $parameters
     * @return \StructType\GetTendersResponse|bool
     */
    public function GetTenders(\StructType\GetTenders $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTenders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetVoidReasons
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetVoidReasons $parameters
     * @return \StructType\GetVoidReasonsResponse|bool
     */
    public function GetVoidReasons(\StructType\GetVoidReasons $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetVoidReasons($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCashDrawersResponse|\StructType\GetDayPartsResponse|\StructType\GetDestinationsResponse|\StructType\GetDiscountsResponse|\StructType\GetEmployeesResponse|\StructType\GetItemGroupsResponse|\StructType\GetItemsResponse|\StructType\GetJobsResponse|\StructType\GetLoyaltyRewardsResponse|\StructType\GetModifierCodesResponse|\StructType\GetModifierGroupsResponse|\StructType\GetOptionsResponse|\StructType\GetPettyAccountsResponse|\StructType\GetPromotionsResponse|\StructType\GetRegistersResponse|\StructType\GetRevenueCentersResponse|\StructType\GetSectionsResponse|\StructType\GetSurchargesResponse|\StructType\GetTaxesResponse|\StructType\GetTendersResponse|\StructType\GetVoidReasonsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
