<?php

namespace EnumType;

/**
 * This class stands for ReconciliationMethod EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReconciliationMethod
 * @subpackage Enumerations
 */
class ReconciliationMethod
{
    /**
     * Constant for value 'Details'
     * @return string 'Details'
     */
    const VALUE_DETAILS = 'Details';
    /**
     * Constant for value 'Totals'
     * @return string 'Totals'
     */
    const VALUE_TOTALS = 'Totals';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DETAILS
     * @uses self::VALUE_TOTALS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DETAILS,
            self::VALUE_TOTALS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
