<?php

namespace EnumType;

/**
 * This class stands for PricePer EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PricePer
 * @subpackage Enumerations
 */
class PricePer
{
    /**
     * Constant for value 'Ounce'
     * @return string 'Ounce'
     */
    const VALUE_OUNCE = 'Ounce';
    /**
     * Constant for value 'Pound'
     * @return string 'Pound'
     */
    const VALUE_POUND = 'Pound';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OUNCE
     * @uses self::VALUE_POUND
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OUNCE,
            self::VALUE_POUND,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
