<?php

namespace EnumType;

/**
 * This class stands for ModCodeType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ModCodeType
 * @subpackage Enumerations
 */
class ModCodeType
{
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'No'
     * @return string 'No'
     */
    const VALUE_NO = 'No';
    /**
     * Constant for value 'For'
     * @return string 'For'
     */
    const VALUE_FOR = 'For';
    /**
     * Constant for value 'Sub'
     * @return string 'Sub'
     */
    const VALUE_SUB = 'Sub';
    /**
     * Constant for value 'OnSide'
     * @return string 'OnSide'
     */
    const VALUE_ON_SIDE = 'OnSide';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_NO
     * @uses self::VALUE_FOR
     * @uses self::VALUE_SUB
     * @uses self::VALUE_ON_SIDE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NORMAL,
            self::VALUE_NO,
            self::VALUE_FOR,
            self::VALUE_SUB,
            self::VALUE_ON_SIDE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
