<?php

namespace EnumType;

/**
 * This class stands for GiftCardItemType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftCardItemType
 * @subpackage Enumerations
 */
class GiftCardItemType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'CashOut'
     * @return string 'CashOut'
     */
    const VALUE_CASH_OUT = 'CashOut';
    /**
     * Constant for value 'Issue'
     * @return string 'Issue'
     */
    const VALUE_ISSUE = 'Issue';
    /**
     * Constant for value 'Reload'
     * @return string 'Reload'
     */
    const VALUE_RELOAD = 'Reload';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_CASH_OUT
     * @uses self::VALUE_ISSUE
     * @uses self::VALUE_RELOAD
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_CASH_OUT,
            self::VALUE_ISSUE,
            self::VALUE_RELOAD,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
