<?php

namespace EnumType;

/**
 * This class stands for DiscountGranularity EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DiscountGranularity
 * @subpackage Enumerations
 */
class DiscountGranularity
{
    /**
     * Constant for value 'Order'
     * @return string 'Order'
     */
    const VALUE_ORDER = 'Order';
    /**
     * Constant for value 'Items'
     * @return string 'Items'
     */
    const VALUE_ITEMS = 'Items';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORDER
     * @uses self::VALUE_ITEMS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORDER,
            self::VALUE_ITEMS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
