<?php

namespace EnumType;

/**
 * This class stands for CardType EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CardType
 * @subpackage Enumerations
 */
class CardType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'MasterCard'
     * @return string 'MasterCard'
     */
    const VALUE_MASTER_CARD = 'MasterCard';
    /**
     * Constant for value 'Visa'
     * @return string 'Visa'
     */
    const VALUE_VISA = 'Visa';
    /**
     * Constant for value 'AmericanExpress'
     * @return string 'AmericanExpress'
     */
    const VALUE_AMERICAN_EXPRESS = 'AmericanExpress';
    /**
     * Constant for value 'Diners'
     * @return string 'Diners'
     */
    const VALUE_DINERS = 'Diners';
    /**
     * Constant for value 'Discover'
     * @return string 'Discover'
     */
    const VALUE_DISCOVER = 'Discover';
    /**
     * Constant for value 'enRoute'
     * @return string 'enRoute'
     */
    const VALUE_EN_ROUTE = 'enRoute';
    /**
     * Constant for value 'JCB'
     * @return string 'JCB'
     */
    const VALUE_JCB = 'JCB';
    /**
     * Constant for value 'Private'
     * @return string 'Private'
     */
    const VALUE_PRIVATE = 'Private';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_MASTER_CARD
     * @uses self::VALUE_VISA
     * @uses self::VALUE_AMERICAN_EXPRESS
     * @uses self::VALUE_DINERS
     * @uses self::VALUE_DISCOVER
     * @uses self::VALUE_EN_ROUTE
     * @uses self::VALUE_JCB
     * @uses self::VALUE_PRIVATE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_MASTER_CARD,
            self::VALUE_VISA,
            self::VALUE_AMERICAN_EXPRESS,
            self::VALUE_DINERS,
            self::VALUE_DISCOVER,
            self::VALUE_EN_ROUTE,
            self::VALUE_JCB,
            self::VALUE_PRIVATE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
