<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTender ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTender
 * @subpackage Arrays
 */
class ArrayOfTender extends AbstractStructArrayBase
{
    /**
     * The Tender
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Tender[]
     */
    public $Tender;
    /**
     * Constructor method for ArrayOfTender
     * @uses ArrayOfTender::setTender()
     * @param \StructType\Tender[] $tender
     */
    public function __construct(array $tender = array())
    {
        $this
            ->setTender($tender);
    }
    /**
     * Get Tender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Tender[]|null
     */
    public function getTender()
    {
        return isset($this->Tender) ? $this->Tender : null;
    }
    /**
     * Set Tender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Tender[] $tender
     * @return \ArrayType\ArrayOfTender
     */
    public function setTender(array $tender = array())
    {
        foreach ($tender as $arrayOfTenderTenderItem) {
            // validation for constraint: itemType
            if (!$arrayOfTenderTenderItem instanceof \StructType\Tender) {
                throw new \InvalidArgumentException(sprintf('The Tender property can only contain items of \StructType\Tender, "%s" given', is_object($arrayOfTenderTenderItem) ? get_class($arrayOfTenderTenderItem) : gettype($arrayOfTenderTenderItem)), __LINE__);
            }
        }
        if (is_null($tender) || (is_array($tender) && empty($tender))) {
            unset($this->Tender);
        } else {
            $this->Tender = $tender;
        }
        return $this;
    }
    /**
     * Add item to Tender value
     * @throws \InvalidArgumentException
     * @param \StructType\Tender $item
     * @return \ArrayType\ArrayOfTender
     */
    public function addToTender(\StructType\Tender $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tender) {
            throw new \InvalidArgumentException(sprintf('The Tender property can only contain items of \StructType\Tender, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Tender[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Tender|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Tender|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Tender|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Tender|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Tender|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Tender
     */
    public function getAttributeName()
    {
        return 'Tender';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfTender
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
