<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSection ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfSection
 * @subpackage Arrays
 */
class ArrayOfSection extends AbstractStructArrayBase
{
    /**
     * The Section
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Section[]
     */
    public $Section;
    /**
     * Constructor method for ArrayOfSection
     * @uses ArrayOfSection::setSection()
     * @param \StructType\Section[] $section
     */
    public function __construct(array $section = array())
    {
        $this
            ->setSection($section);
    }
    /**
     * Get Section value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Section[]|null
     */
    public function getSection()
    {
        return isset($this->Section) ? $this->Section : null;
    }
    /**
     * Set Section value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Section[] $section
     * @return \ArrayType\ArrayOfSection
     */
    public function setSection(array $section = array())
    {
        foreach ($section as $arrayOfSectionSectionItem) {
            // validation for constraint: itemType
            if (!$arrayOfSectionSectionItem instanceof \StructType\Section) {
                throw new \InvalidArgumentException(sprintf('The Section property can only contain items of \StructType\Section, "%s" given', is_object($arrayOfSectionSectionItem) ? get_class($arrayOfSectionSectionItem) : gettype($arrayOfSectionSectionItem)), __LINE__);
            }
        }
        if (is_null($section) || (is_array($section) && empty($section))) {
            unset($this->Section);
        } else {
            $this->Section = $section;
        }
        return $this;
    }
    /**
     * Add item to Section value
     * @throws \InvalidArgumentException
     * @param \StructType\Section $item
     * @return \ArrayType\ArrayOfSection
     */
    public function addToSection(\StructType\Section $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Section) {
            throw new \InvalidArgumentException(sprintf('The Section property can only contain items of \StructType\Section, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Section[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Section|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Section|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Section|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Section|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Section|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Section
     */
    public function getAttributeName()
    {
        return 'Section';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfSection
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
