<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemGroupItem ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfItemGroupItem
 * @subpackage Arrays
 */
class ArrayOfItemGroupItem extends AbstractStructArrayBase
{
    /**
     * The ItemGroupItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemGroupItem[]
     */
    public $ItemGroupItem;
    /**
     * Constructor method for ArrayOfItemGroupItem
     * @uses ArrayOfItemGroupItem::setItemGroupItem()
     * @param \StructType\ItemGroupItem[] $itemGroupItem
     */
    public function __construct(array $itemGroupItem = array())
    {
        $this
            ->setItemGroupItem($itemGroupItem);
    }
    /**
     * Get ItemGroupItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemGroupItem[]|null
     */
    public function getItemGroupItem()
    {
        return isset($this->ItemGroupItem) ? $this->ItemGroupItem : null;
    }
    /**
     * Set ItemGroupItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemGroupItem[] $itemGroupItem
     * @return \ArrayType\ArrayOfItemGroupItem
     */
    public function setItemGroupItem(array $itemGroupItem = array())
    {
        foreach ($itemGroupItem as $arrayOfItemGroupItemItemGroupItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemGroupItemItemGroupItemItem instanceof \StructType\ItemGroupItem) {
                throw new \InvalidArgumentException(sprintf('The ItemGroupItem property can only contain items of \StructType\ItemGroupItem, "%s" given', is_object($arrayOfItemGroupItemItemGroupItemItem) ? get_class($arrayOfItemGroupItemItemGroupItemItem) : gettype($arrayOfItemGroupItemItemGroupItemItem)), __LINE__);
            }
        }
        if (is_null($itemGroupItem) || (is_array($itemGroupItem) && empty($itemGroupItem))) {
            unset($this->ItemGroupItem);
        } else {
            $this->ItemGroupItem = $itemGroupItem;
        }
        return $this;
    }
    /**
     * Add item to ItemGroupItem value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemGroupItem $item
     * @return \ArrayType\ArrayOfItemGroupItem
     */
    public function addToItemGroupItem(\StructType\ItemGroupItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemGroupItem) {
            throw new \InvalidArgumentException(sprintf('The ItemGroupItem property can only contain items of \StructType\ItemGroupItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemGroupItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemGroupItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemGroupItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemGroupItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemGroupItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemGroupItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemGroupItem
     */
    public function getAttributeName()
    {
        return 'ItemGroupItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItemGroupItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
