<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfItemCompositeComponent ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfItemCompositeComponent
 * @subpackage Arrays
 */
class ArrayOfItemCompositeComponent extends AbstractStructArrayBase
{
    /**
     * The ItemCompositeComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ItemCompositeComponent[]
     */
    public $ItemCompositeComponent;
    /**
     * Constructor method for ArrayOfItemCompositeComponent
     * @uses ArrayOfItemCompositeComponent::setItemCompositeComponent()
     * @param \StructType\ItemCompositeComponent[] $itemCompositeComponent
     */
    public function __construct(array $itemCompositeComponent = array())
    {
        $this
            ->setItemCompositeComponent($itemCompositeComponent);
    }
    /**
     * Get ItemCompositeComponent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ItemCompositeComponent[]|null
     */
    public function getItemCompositeComponent()
    {
        return isset($this->ItemCompositeComponent) ? $this->ItemCompositeComponent : null;
    }
    /**
     * Set ItemCompositeComponent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ItemCompositeComponent[] $itemCompositeComponent
     * @return \ArrayType\ArrayOfItemCompositeComponent
     */
    public function setItemCompositeComponent(array $itemCompositeComponent = array())
    {
        foreach ($itemCompositeComponent as $arrayOfItemCompositeComponentItemCompositeComponentItem) {
            // validation for constraint: itemType
            if (!$arrayOfItemCompositeComponentItemCompositeComponentItem instanceof \StructType\ItemCompositeComponent) {
                throw new \InvalidArgumentException(sprintf('The ItemCompositeComponent property can only contain items of \StructType\ItemCompositeComponent, "%s" given', is_object($arrayOfItemCompositeComponentItemCompositeComponentItem) ? get_class($arrayOfItemCompositeComponentItemCompositeComponentItem) : gettype($arrayOfItemCompositeComponentItemCompositeComponentItem)), __LINE__);
            }
        }
        if (is_null($itemCompositeComponent) || (is_array($itemCompositeComponent) && empty($itemCompositeComponent))) {
            unset($this->ItemCompositeComponent);
        } else {
            $this->ItemCompositeComponent = $itemCompositeComponent;
        }
        return $this;
    }
    /**
     * Add item to ItemCompositeComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemCompositeComponent $item
     * @return \ArrayType\ArrayOfItemCompositeComponent
     */
    public function addToItemCompositeComponent(\StructType\ItemCompositeComponent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemCompositeComponent) {
            throw new \InvalidArgumentException(sprintf('The ItemCompositeComponent property can only contain items of \StructType\ItemCompositeComponent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemCompositeComponent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemCompositeComponent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemCompositeComponent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemCompositeComponent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemCompositeComponent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemCompositeComponent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemCompositeComponent
     */
    public function getAttributeName()
    {
        return 'ItemCompositeComponent';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfItemCompositeComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
