<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TiePairInformationType StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:TiePairInformationType
 * @subpackage Structs
 */
class TiePairInformationType extends AbstractStructBase
{
    /**
     * The CSRICardRecoverable
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CSRICardRecoverable;
    /**
     * The TieCableOrdered
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TieCableOrdered;
    /**
     * The TieCableStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TieCableStatus;
    /**
     * Constructor method for TiePairInformationType
     * @uses TiePairInformationType::setCSRICardRecoverable()
     * @uses TiePairInformationType::setTieCableOrdered()
     * @uses TiePairInformationType::setTieCableStatus()
     * @param string $cSRICardRecoverable
     * @param string $tieCableOrdered
     * @param string $tieCableStatus
     */
    public function __construct($cSRICardRecoverable = null, $tieCableOrdered = null, $tieCableStatus = null)
    {
        $this
            ->setCSRICardRecoverable($cSRICardRecoverable)
            ->setTieCableOrdered($tieCableOrdered)
            ->setTieCableStatus($tieCableStatus);
    }
    /**
     * Get CSRICardRecoverable value
     * @return string|null
     */
    public function getCSRICardRecoverable()
    {
        return $this->CSRICardRecoverable;
    }
    /**
     * Set CSRICardRecoverable value
     * @uses \EnumType\CSRICardRecoverable::valueIsValid()
     * @uses \EnumType\CSRICardRecoverable::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cSRICardRecoverable
     * @return \StructType\TiePairInformationType
     */
    public function setCSRICardRecoverable($cSRICardRecoverable = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CSRICardRecoverable::valueIsValid($cSRICardRecoverable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $cSRICardRecoverable, implode(', ', \EnumType\CSRICardRecoverable::getValidValues())), __LINE__);
        }
        $this->CSRICardRecoverable = $cSRICardRecoverable;
        return $this;
    }
    /**
     * Get TieCableOrdered value
     * @return string|null
     */
    public function getTieCableOrdered()
    {
        return $this->TieCableOrdered;
    }
    /**
     * Set TieCableOrdered value
     * @uses \EnumType\TieCableOrdered::valueIsValid()
     * @uses \EnumType\TieCableOrdered::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tieCableOrdered
     * @return \StructType\TiePairInformationType
     */
    public function setTieCableOrdered($tieCableOrdered = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TieCableOrdered::valueIsValid($tieCableOrdered)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tieCableOrdered, implode(', ', \EnumType\TieCableOrdered::getValidValues())), __LINE__);
        }
        $this->TieCableOrdered = $tieCableOrdered;
        return $this;
    }
    /**
     * Get TieCableStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTieCableStatus()
    {
        return isset($this->TieCableStatus) ? $this->TieCableStatus : null;
    }
    /**
     * Set TieCableStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tieCableStatus
     * @return \StructType\TiePairInformationType
     */
    public function setTieCableStatus($tieCableStatus = null)
    {
        // validation for constraint: string
        if (!is_null($tieCableStatus) && !is_string($tieCableStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tieCableStatus)), __LINE__);
        }
        if (is_null($tieCableStatus) || (is_array($tieCableStatus) && empty($tieCableStatus))) {
            unset($this->TieCableStatus);
        } else {
            $this->TieCableStatus = $tieCableStatus;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TiePairInformationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
