<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductMessage StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductMessage
 * @subpackage Structs
 */
class ProductMessage extends AbstractStructBase
{
    /**
     * The ProductAttributes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProductAttribute
     */
    public $ProductAttributes;
    /**
     * The ProductCategory
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductCategory;
    /**
     * Constructor method for ProductMessage
     * @uses ProductMessage::setProductAttributes()
     * @uses ProductMessage::setProductCategory()
     * @param \ArrayType\ArrayOfProductAttribute $productAttributes
     * @param string $productCategory
     */
    public function __construct(\ArrayType\ArrayOfProductAttribute $productAttributes = null, $productCategory = null)
    {
        $this
            ->setProductAttributes($productAttributes)
            ->setProductCategory($productCategory);
    }
    /**
     * Get ProductAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProductAttribute|null
     */
    public function getProductAttributes()
    {
        return isset($this->ProductAttributes) ? $this->ProductAttributes : null;
    }
    /**
     * Set ProductAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProductAttribute $productAttributes
     * @return \StructType\ProductMessage
     */
    public function setProductAttributes(\ArrayType\ArrayOfProductAttribute $productAttributes = null)
    {
        if (is_null($productAttributes) || (is_array($productAttributes) && empty($productAttributes))) {
            unset($this->ProductAttributes);
        } else {
            $this->ProductAttributes = $productAttributes;
        }
        return $this;
    }
    /**
     * Get ProductCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductCategory()
    {
        return isset($this->ProductCategory) ? $this->ProductCategory : null;
    }
    /**
     * Set ProductCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productCategory
     * @return \StructType\ProductMessage
     */
    public function setProductCategory($productCategory = null)
    {
        // validation for constraint: string
        if (!is_null($productCategory) && !is_string($productCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productCategory)), __LINE__);
        }
        if (is_null($productCategory) || (is_array($productCategory) && empty($productCategory))) {
            unset($this->ProductCategory);
        } else {
            $this->ProductCategory = $productCategory;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductMessage
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
