<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostcodeAvailabilityRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PostcodeAvailabilityRequest
 * @subpackage Structs
 */
class PostcodeAvailabilityRequest extends AvailabilityRequest
{
    /**
     * The PerformMPFACCheck
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PerformMPFACCheck;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The UPRN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UPRN;
    /**
     * Constructor method for PostcodeAvailabilityRequest
     * @uses PostcodeAvailabilityRequest::setPerformMPFACCheck()
     * @uses PostcodeAvailabilityRequest::setPostcode()
     * @uses PostcodeAvailabilityRequest::setUPRN()
     * @param string $performMPFACCheck
     * @param string $postcode
     * @param int $uPRN
     */
    public function __construct($performMPFACCheck = null, $postcode = null, $uPRN = null)
    {
        $this
            ->setPerformMPFACCheck($performMPFACCheck)
            ->setPostcode($postcode)
            ->setUPRN($uPRN);
    }
    /**
     * Get PerformMPFACCheck value
     * @return string|null
     */
    public function getPerformMPFACCheck()
    {
        return $this->PerformMPFACCheck;
    }
    /**
     * Set PerformMPFACCheck value
     * @uses \EnumType\PerformMPFACCheckEnum::valueIsValid()
     * @uses \EnumType\PerformMPFACCheckEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $performMPFACCheck
     * @return \StructType\PostcodeAvailabilityRequest
     */
    public function setPerformMPFACCheck($performMPFACCheck = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PerformMPFACCheckEnum::valueIsValid($performMPFACCheck)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $performMPFACCheck, implode(', ', \EnumType\PerformMPFACCheckEnum::getValidValues())), __LINE__);
        }
        $this->PerformMPFACCheck = $performMPFACCheck;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\PostcodeAvailabilityRequest
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get UPRN value
     * @return int|null
     */
    public function getUPRN()
    {
        return $this->UPRN;
    }
    /**
     * Set UPRN value
     * @param int $uPRN
     * @return \StructType\PostcodeAvailabilityRequest
     */
    public function setUPRN($uPRN = null)
    {
        // validation for constraint: int
        if (!is_null($uPRN) && !is_numeric($uPRN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uPRN)), __LINE__);
        }
        $this->UPRN = $uPRN;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PostcodeAvailabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
