<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpenOrderInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OpenOrderInfo
 * @subpackage Structs
 */
class OpenOrderInfo extends AbstractStructBase
{
    /**
     * The CommandId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommandId;
    /**
     * The OrderTargetDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeDetails
     */
    public $OrderTargetDate;
    /**
     * The OrderType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderType;
    /**
     * The OrderTypeOrigin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderTypeOrigin;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceType;
    /**
     * Constructor method for OpenOrderInfo
     * @uses OpenOrderInfo::setCommandId()
     * @uses OpenOrderInfo::setOrderTargetDate()
     * @uses OpenOrderInfo::setOrderType()
     * @uses OpenOrderInfo::setOrderTypeOrigin()
     * @uses OpenOrderInfo::setServiceType()
     * @param string $commandId
     * @param \StructType\DateTimeDetails $orderTargetDate
     * @param string $orderType
     * @param string $orderTypeOrigin
     * @param string $serviceType
     */
    public function __construct($commandId = null, \StructType\DateTimeDetails $orderTargetDate = null, $orderType = null, $orderTypeOrigin = null, $serviceType = null)
    {
        $this
            ->setCommandId($commandId)
            ->setOrderTargetDate($orderTargetDate)
            ->setOrderType($orderType)
            ->setOrderTypeOrigin($orderTypeOrigin)
            ->setServiceType($serviceType);
    }
    /**
     * Get CommandId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommandId()
    {
        return isset($this->CommandId) ? $this->CommandId : null;
    }
    /**
     * Set CommandId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commandId
     * @return \StructType\OpenOrderInfo
     */
    public function setCommandId($commandId = null)
    {
        // validation for constraint: string
        if (!is_null($commandId) && !is_string($commandId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($commandId)), __LINE__);
        }
        if (is_null($commandId) || (is_array($commandId) && empty($commandId))) {
            unset($this->CommandId);
        } else {
            $this->CommandId = $commandId;
        }
        return $this;
    }
    /**
     * Get OrderTargetDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeDetails|null
     */
    public function getOrderTargetDate()
    {
        return isset($this->OrderTargetDate) ? $this->OrderTargetDate : null;
    }
    /**
     * Set OrderTargetDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeDetails $orderTargetDate
     * @return \StructType\OpenOrderInfo
     */
    public function setOrderTargetDate(\StructType\DateTimeDetails $orderTargetDate = null)
    {
        if (is_null($orderTargetDate) || (is_array($orderTargetDate) && empty($orderTargetDate))) {
            unset($this->OrderTargetDate);
        } else {
            $this->OrderTargetDate = $orderTargetDate;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderType
     * @return \StructType\OpenOrderInfo
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: string
        if (!is_null($orderType) && !is_string($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderType)), __LINE__);
        }
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get OrderTypeOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderTypeOrigin()
    {
        return isset($this->OrderTypeOrigin) ? $this->OrderTypeOrigin : null;
    }
    /**
     * Set OrderTypeOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderTypeOrigin
     * @return \StructType\OpenOrderInfo
     */
    public function setOrderTypeOrigin($orderTypeOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($orderTypeOrigin) && !is_string($orderTypeOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderTypeOrigin)), __LINE__);
        }
        if (is_null($orderTypeOrigin) || (is_array($orderTypeOrigin) && empty($orderTypeOrigin))) {
            unset($this->OrderTypeOrigin);
        } else {
            $this->OrderTypeOrigin = $orderTypeOrigin;
        }
        return $this;
    }
    /**
     * Get ServiceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceType()
    {
        return isset($this->ServiceType) ? $this->ServiceType : null;
    }
    /**
     * Set ServiceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceType
     * @return \StructType\OpenOrderInfo
     */
    public function setServiceType($serviceType = null)
    {
        // validation for constraint: string
        if (!is_null($serviceType) && !is_string($serviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceType)), __LINE__);
        }
        if (is_null($serviceType) || (is_array($serviceType) && empty($serviceType))) {
            unset($this->ServiceType);
        } else {
            $this->ServiceType = $serviceType;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OpenOrderInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
