<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffnetLineDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OffnetLineDetails
 * @subpackage Structs
 */
class OffnetLineDetails extends AbstractStructBase
{
    /**
     * The CADPending
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CADPending;
    /**
     * The CPContactNo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPContactNo;
    /**
     * The CPName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPName;
    /**
     * The ReasonCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReasonCode;
    /**
     * The SPName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SPName;
    /**
     * Constructor method for OffnetLineDetails
     * @uses OffnetLineDetails::setCADPending()
     * @uses OffnetLineDetails::setCPContactNo()
     * @uses OffnetLineDetails::setCPName()
     * @uses OffnetLineDetails::setReasonCode()
     * @uses OffnetLineDetails::setSPName()
     * @param string $cADPending
     * @param string $cPContactNo
     * @param string $cPName
     * @param string $reasonCode
     * @param string $sPName
     */
    public function __construct($cADPending = null, $cPContactNo = null, $cPName = null, $reasonCode = null, $sPName = null)
    {
        $this
            ->setCADPending($cADPending)
            ->setCPContactNo($cPContactNo)
            ->setCPName($cPName)
            ->setReasonCode($reasonCode)
            ->setSPName($sPName);
    }
    /**
     * Get CADPending value
     * @return string|null
     */
    public function getCADPending()
    {
        return $this->CADPending;
    }
    /**
     * Set CADPending value
     * @param string $cADPending
     * @return \StructType\OffnetLineDetails
     */
    public function setCADPending($cADPending = null)
    {
        // validation for constraint: string
        if (!is_null($cADPending) && !is_string($cADPending)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cADPending)), __LINE__);
        }
        $this->CADPending = $cADPending;
        return $this;
    }
    /**
     * Get CPContactNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPContactNo()
    {
        return isset($this->CPContactNo) ? $this->CPContactNo : null;
    }
    /**
     * Set CPContactNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPContactNo
     * @return \StructType\OffnetLineDetails
     */
    public function setCPContactNo($cPContactNo = null)
    {
        // validation for constraint: string
        if (!is_null($cPContactNo) && !is_string($cPContactNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cPContactNo)), __LINE__);
        }
        if (is_null($cPContactNo) || (is_array($cPContactNo) && empty($cPContactNo))) {
            unset($this->CPContactNo);
        } else {
            $this->CPContactNo = $cPContactNo;
        }
        return $this;
    }
    /**
     * Get CPName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPName()
    {
        return isset($this->CPName) ? $this->CPName : null;
    }
    /**
     * Set CPName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPName
     * @return \StructType\OffnetLineDetails
     */
    public function setCPName($cPName = null)
    {
        // validation for constraint: string
        if (!is_null($cPName) && !is_string($cPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cPName)), __LINE__);
        }
        if (is_null($cPName) || (is_array($cPName) && empty($cPName))) {
            unset($this->CPName);
        } else {
            $this->CPName = $cPName;
        }
        return $this;
    }
    /**
     * Get ReasonCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReasonCode()
    {
        return isset($this->ReasonCode) ? $this->ReasonCode : null;
    }
    /**
     * Set ReasonCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reasonCode
     * @return \StructType\OffnetLineDetails
     */
    public function setReasonCode($reasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($reasonCode) && !is_string($reasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reasonCode)), __LINE__);
        }
        if (is_null($reasonCode) || (is_array($reasonCode) && empty($reasonCode))) {
            unset($this->ReasonCode);
        } else {
            $this->ReasonCode = $reasonCode;
        }
        return $this;
    }
    /**
     * Get SPName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSPName()
    {
        return isset($this->SPName) ? $this->SPName : null;
    }
    /**
     * Set SPName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sPName
     * @return \StructType\OffnetLineDetails
     */
    public function setSPName($sPName = null)
    {
        // validation for constraint: string
        if (!is_null($sPName) && !is_string($sPName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sPName)), __LINE__);
        }
        if (is_null($sPName) || (is_array($sPName) && empty($sPName))) {
            unset($this->SPName);
        } else {
            $this->SPName = $sPName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OffnetLineDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
