<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffnetAvailabilityDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OffnetAvailabilityDetails
 * @subpackage Structs
 */
class OffnetAvailabilityDetails extends AvailabilityDetails
{
    /**
     * The ADSL2PLUSAvailabilityInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ADSL2PLUSAvailabilityDetails
     */
    public $ADSL2PLUSAvailabilityInfo;
    /**
     * The ADSLAvailabilityInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ADSLAvailabilityDetails
     */
    public $ADSLAvailabilityInfo;
    /**
     * The AccessLevelKey
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessLevelKey;
    /**
     * The AdditionalMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AdditionalMessagesDetails
     */
    public $AdditionalMessages;
    /**
     * The ExchangeInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OffnetExchangeDetails
     */
    public $ExchangeInfo;
    /**
     * The LineInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OffnetLineDetails
     */
    public $LineInfo;
    /**
     * The LineManagementInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OffnetLineManagementDetails
     */
    public $LineManagementInfo;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Postcode;
    /**
     * The PostcodeMatch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PostcodeMatch;
    /**
     * The TelephoneNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TelephoneNumber;
    /**
     * Constructor method for OffnetAvailabilityDetails
     * @uses OffnetAvailabilityDetails::setADSL2PLUSAvailabilityInfo()
     * @uses OffnetAvailabilityDetails::setADSLAvailabilityInfo()
     * @uses OffnetAvailabilityDetails::setAccessLevelKey()
     * @uses OffnetAvailabilityDetails::setAdditionalMessages()
     * @uses OffnetAvailabilityDetails::setExchangeInfo()
     * @uses OffnetAvailabilityDetails::setLineInfo()
     * @uses OffnetAvailabilityDetails::setLineManagementInfo()
     * @uses OffnetAvailabilityDetails::setPostcode()
     * @uses OffnetAvailabilityDetails::setPostcodeMatch()
     * @uses OffnetAvailabilityDetails::setTelephoneNumber()
     * @param \StructType\ADSL2PLUSAvailabilityDetails $aDSL2PLUSAvailabilityInfo
     * @param \StructType\ADSLAvailabilityDetails $aDSLAvailabilityInfo
     * @param string $accessLevelKey
     * @param \StructType\AdditionalMessagesDetails $additionalMessages
     * @param \StructType\OffnetExchangeDetails $exchangeInfo
     * @param \StructType\OffnetLineDetails $lineInfo
     * @param \StructType\OffnetLineManagementDetails $lineManagementInfo
     * @param string $postcode
     * @param string $postcodeMatch
     * @param string $telephoneNumber
     */
    public function __construct(\StructType\ADSL2PLUSAvailabilityDetails $aDSL2PLUSAvailabilityInfo = null, \StructType\ADSLAvailabilityDetails $aDSLAvailabilityInfo = null, $accessLevelKey = null, \StructType\AdditionalMessagesDetails $additionalMessages = null, \StructType\OffnetExchangeDetails $exchangeInfo = null, \StructType\OffnetLineDetails $lineInfo = null, \StructType\OffnetLineManagementDetails $lineManagementInfo = null, $postcode = null, $postcodeMatch = null, $telephoneNumber = null)
    {
        $this
            ->setADSL2PLUSAvailabilityInfo($aDSL2PLUSAvailabilityInfo)
            ->setADSLAvailabilityInfo($aDSLAvailabilityInfo)
            ->setAccessLevelKey($accessLevelKey)
            ->setAdditionalMessages($additionalMessages)
            ->setExchangeInfo($exchangeInfo)
            ->setLineInfo($lineInfo)
            ->setLineManagementInfo($lineManagementInfo)
            ->setPostcode($postcode)
            ->setPostcodeMatch($postcodeMatch)
            ->setTelephoneNumber($telephoneNumber);
    }
    /**
     * Get ADSL2PLUSAvailabilityInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ADSL2PLUSAvailabilityDetails|null
     */
    public function getADSL2PLUSAvailabilityInfo()
    {
        return isset($this->ADSL2PLUSAvailabilityInfo) ? $this->ADSL2PLUSAvailabilityInfo : null;
    }
    /**
     * Set ADSL2PLUSAvailabilityInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ADSL2PLUSAvailabilityDetails $aDSL2PLUSAvailabilityInfo
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setADSL2PLUSAvailabilityInfo(\StructType\ADSL2PLUSAvailabilityDetails $aDSL2PLUSAvailabilityInfo = null)
    {
        if (is_null($aDSL2PLUSAvailabilityInfo) || (is_array($aDSL2PLUSAvailabilityInfo) && empty($aDSL2PLUSAvailabilityInfo))) {
            unset($this->ADSL2PLUSAvailabilityInfo);
        } else {
            $this->ADSL2PLUSAvailabilityInfo = $aDSL2PLUSAvailabilityInfo;
        }
        return $this;
    }
    /**
     * Get ADSLAvailabilityInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ADSLAvailabilityDetails|null
     */
    public function getADSLAvailabilityInfo()
    {
        return isset($this->ADSLAvailabilityInfo) ? $this->ADSLAvailabilityInfo : null;
    }
    /**
     * Set ADSLAvailabilityInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ADSLAvailabilityDetails $aDSLAvailabilityInfo
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setADSLAvailabilityInfo(\StructType\ADSLAvailabilityDetails $aDSLAvailabilityInfo = null)
    {
        if (is_null($aDSLAvailabilityInfo) || (is_array($aDSLAvailabilityInfo) && empty($aDSLAvailabilityInfo))) {
            unset($this->ADSLAvailabilityInfo);
        } else {
            $this->ADSLAvailabilityInfo = $aDSLAvailabilityInfo;
        }
        return $this;
    }
    /**
     * Get AccessLevelKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessLevelKey()
    {
        return isset($this->AccessLevelKey) ? $this->AccessLevelKey : null;
    }
    /**
     * Set AccessLevelKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessLevelKey
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setAccessLevelKey($accessLevelKey = null)
    {
        // validation for constraint: string
        if (!is_null($accessLevelKey) && !is_string($accessLevelKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accessLevelKey)), __LINE__);
        }
        if (is_null($accessLevelKey) || (is_array($accessLevelKey) && empty($accessLevelKey))) {
            unset($this->AccessLevelKey);
        } else {
            $this->AccessLevelKey = $accessLevelKey;
        }
        return $this;
    }
    /**
     * Get AdditionalMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AdditionalMessagesDetails|null
     */
    public function getAdditionalMessages()
    {
        return isset($this->AdditionalMessages) ? $this->AdditionalMessages : null;
    }
    /**
     * Set AdditionalMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AdditionalMessagesDetails $additionalMessages
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setAdditionalMessages(\StructType\AdditionalMessagesDetails $additionalMessages = null)
    {
        if (is_null($additionalMessages) || (is_array($additionalMessages) && empty($additionalMessages))) {
            unset($this->AdditionalMessages);
        } else {
            $this->AdditionalMessages = $additionalMessages;
        }
        return $this;
    }
    /**
     * Get ExchangeInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OffnetExchangeDetails|null
     */
    public function getExchangeInfo()
    {
        return isset($this->ExchangeInfo) ? $this->ExchangeInfo : null;
    }
    /**
     * Set ExchangeInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OffnetExchangeDetails $exchangeInfo
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setExchangeInfo(\StructType\OffnetExchangeDetails $exchangeInfo = null)
    {
        if (is_null($exchangeInfo) || (is_array($exchangeInfo) && empty($exchangeInfo))) {
            unset($this->ExchangeInfo);
        } else {
            $this->ExchangeInfo = $exchangeInfo;
        }
        return $this;
    }
    /**
     * Get LineInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OffnetLineDetails|null
     */
    public function getLineInfo()
    {
        return isset($this->LineInfo) ? $this->LineInfo : null;
    }
    /**
     * Set LineInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OffnetLineDetails $lineInfo
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setLineInfo(\StructType\OffnetLineDetails $lineInfo = null)
    {
        if (is_null($lineInfo) || (is_array($lineInfo) && empty($lineInfo))) {
            unset($this->LineInfo);
        } else {
            $this->LineInfo = $lineInfo;
        }
        return $this;
    }
    /**
     * Get LineManagementInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OffnetLineManagementDetails|null
     */
    public function getLineManagementInfo()
    {
        return isset($this->LineManagementInfo) ? $this->LineManagementInfo : null;
    }
    /**
     * Set LineManagementInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OffnetLineManagementDetails $lineManagementInfo
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setLineManagementInfo(\StructType\OffnetLineManagementDetails $lineManagementInfo = null)
    {
        if (is_null($lineManagementInfo) || (is_array($lineManagementInfo) && empty($lineManagementInfo))) {
            unset($this->LineManagementInfo);
        } else {
            $this->LineManagementInfo = $lineManagementInfo;
        }
        return $this;
    }
    /**
     * Get Postcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostcode()
    {
        return isset($this->Postcode) ? $this->Postcode : null;
    }
    /**
     * Set Postcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postcode
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        if (is_null($postcode) || (is_array($postcode) && empty($postcode))) {
            unset($this->Postcode);
        } else {
            $this->Postcode = $postcode;
        }
        return $this;
    }
    /**
     * Get PostcodeMatch value
     * @return string|null
     */
    public function getPostcodeMatch()
    {
        return $this->PostcodeMatch;
    }
    /**
     * Set PostcodeMatch value
     * @uses \EnumType\NotSetYesNoEnum::valueIsValid()
     * @uses \EnumType\NotSetYesNoEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $postcodeMatch
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setPostcodeMatch($postcodeMatch = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NotSetYesNoEnum::valueIsValid($postcodeMatch)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $postcodeMatch, implode(', ', \EnumType\NotSetYesNoEnum::getValidValues())), __LINE__);
        }
        $this->PostcodeMatch = $postcodeMatch;
        return $this;
    }
    /**
     * Get TelephoneNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephoneNumber()
    {
        return isset($this->TelephoneNumber) ? $this->TelephoneNumber : null;
    }
    /**
     * Set TelephoneNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephoneNumber
     * @return \StructType\OffnetAvailabilityDetails
     */
    public function setTelephoneNumber($telephoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($telephoneNumber) && !is_string($telephoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephoneNumber)), __LINE__);
        }
        if (is_null($telephoneNumber) || (is_array($telephoneNumber) && empty($telephoneNumber))) {
            unset($this->TelephoneNumber);
        } else {
            $this->TelephoneNumber = $telephoneNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OffnetAvailabilityDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
