<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NominatedCLIDetails StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NominatedCLIDetails
 * @subpackage Structs
 */
class NominatedCLIDetails extends ResponseBase
{
    /**
     * The CompatibilityStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompatibilityStatus;
    /**
     * The NumberRangeOwner
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberRangeOwner;
    /**
     * The NumberRetentionCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumberRetentionCode;
    /**
     * The NumberRetentionCodeExpiryDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NumberRetentionCodeExpiryDate;
    /**
     * The OpenOrders
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrdersInformation
     */
    public $OpenOrders;
    /**
     * The PortStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PortStatus;
    /**
     * The RetentionStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RetentionStatus;
    /**
     * The ServiceIncompatibility
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceIncompatibility;
    /**
     * Constructor method for NominatedCLIDetails
     * @uses NominatedCLIDetails::setCompatibilityStatus()
     * @uses NominatedCLIDetails::setNumberRangeOwner()
     * @uses NominatedCLIDetails::setNumberRetentionCode()
     * @uses NominatedCLIDetails::setNumberRetentionCodeExpiryDate()
     * @uses NominatedCLIDetails::setOpenOrders()
     * @uses NominatedCLIDetails::setPortStatus()
     * @uses NominatedCLIDetails::setRetentionStatus()
     * @uses NominatedCLIDetails::setServiceIncompatibility()
     * @param string $compatibilityStatus
     * @param string $numberRangeOwner
     * @param string $numberRetentionCode
     * @param string $numberRetentionCodeExpiryDate
     * @param \StructType\OrdersInformation $openOrders
     * @param string $portStatus
     * @param string $retentionStatus
     * @param string $serviceIncompatibility
     */
    public function __construct($compatibilityStatus = null, $numberRangeOwner = null, $numberRetentionCode = null, $numberRetentionCodeExpiryDate = null, \StructType\OrdersInformation $openOrders = null, $portStatus = null, $retentionStatus = null, $serviceIncompatibility = null)
    {
        $this
            ->setCompatibilityStatus($compatibilityStatus)
            ->setNumberRangeOwner($numberRangeOwner)
            ->setNumberRetentionCode($numberRetentionCode)
            ->setNumberRetentionCodeExpiryDate($numberRetentionCodeExpiryDate)
            ->setOpenOrders($openOrders)
            ->setPortStatus($portStatus)
            ->setRetentionStatus($retentionStatus)
            ->setServiceIncompatibility($serviceIncompatibility);
    }
    /**
     * Get CompatibilityStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompatibilityStatus()
    {
        return isset($this->CompatibilityStatus) ? $this->CompatibilityStatus : null;
    }
    /**
     * Set CompatibilityStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $compatibilityStatus
     * @return \StructType\NominatedCLIDetails
     */
    public function setCompatibilityStatus($compatibilityStatus = null)
    {
        // validation for constraint: string
        if (!is_null($compatibilityStatus) && !is_string($compatibilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($compatibilityStatus)), __LINE__);
        }
        if (is_null($compatibilityStatus) || (is_array($compatibilityStatus) && empty($compatibilityStatus))) {
            unset($this->CompatibilityStatus);
        } else {
            $this->CompatibilityStatus = $compatibilityStatus;
        }
        return $this;
    }
    /**
     * Get NumberRangeOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberRangeOwner()
    {
        return isset($this->NumberRangeOwner) ? $this->NumberRangeOwner : null;
    }
    /**
     * Set NumberRangeOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberRangeOwner
     * @return \StructType\NominatedCLIDetails
     */
    public function setNumberRangeOwner($numberRangeOwner = null)
    {
        // validation for constraint: string
        if (!is_null($numberRangeOwner) && !is_string($numberRangeOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberRangeOwner)), __LINE__);
        }
        if (is_null($numberRangeOwner) || (is_array($numberRangeOwner) && empty($numberRangeOwner))) {
            unset($this->NumberRangeOwner);
        } else {
            $this->NumberRangeOwner = $numberRangeOwner;
        }
        return $this;
    }
    /**
     * Get NumberRetentionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumberRetentionCode()
    {
        return isset($this->NumberRetentionCode) ? $this->NumberRetentionCode : null;
    }
    /**
     * Set NumberRetentionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numberRetentionCode
     * @return \StructType\NominatedCLIDetails
     */
    public function setNumberRetentionCode($numberRetentionCode = null)
    {
        // validation for constraint: string
        if (!is_null($numberRetentionCode) && !is_string($numberRetentionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberRetentionCode)), __LINE__);
        }
        if (is_null($numberRetentionCode) || (is_array($numberRetentionCode) && empty($numberRetentionCode))) {
            unset($this->NumberRetentionCode);
        } else {
            $this->NumberRetentionCode = $numberRetentionCode;
        }
        return $this;
    }
    /**
     * Get NumberRetentionCodeExpiryDate value
     * @return string|null
     */
    public function getNumberRetentionCodeExpiryDate()
    {
        return $this->NumberRetentionCodeExpiryDate;
    }
    /**
     * Set NumberRetentionCodeExpiryDate value
     * @param string $numberRetentionCodeExpiryDate
     * @return \StructType\NominatedCLIDetails
     */
    public function setNumberRetentionCodeExpiryDate($numberRetentionCodeExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($numberRetentionCodeExpiryDate) && !is_string($numberRetentionCodeExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numberRetentionCodeExpiryDate)), __LINE__);
        }
        $this->NumberRetentionCodeExpiryDate = $numberRetentionCodeExpiryDate;
        return $this;
    }
    /**
     * Get OpenOrders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrdersInformation|null
     */
    public function getOpenOrders()
    {
        return isset($this->OpenOrders) ? $this->OpenOrders : null;
    }
    /**
     * Set OpenOrders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OrdersInformation $openOrders
     * @return \StructType\NominatedCLIDetails
     */
    public function setOpenOrders(\StructType\OrdersInformation $openOrders = null)
    {
        if (is_null($openOrders) || (is_array($openOrders) && empty($openOrders))) {
            unset($this->OpenOrders);
        } else {
            $this->OpenOrders = $openOrders;
        }
        return $this;
    }
    /**
     * Get PortStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPortStatus()
    {
        return isset($this->PortStatus) ? $this->PortStatus : null;
    }
    /**
     * Set PortStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $portStatus
     * @return \StructType\NominatedCLIDetails
     */
    public function setPortStatus($portStatus = null)
    {
        // validation for constraint: string
        if (!is_null($portStatus) && !is_string($portStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($portStatus)), __LINE__);
        }
        if (is_null($portStatus) || (is_array($portStatus) && empty($portStatus))) {
            unset($this->PortStatus);
        } else {
            $this->PortStatus = $portStatus;
        }
        return $this;
    }
    /**
     * Get RetentionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRetentionStatus()
    {
        return isset($this->RetentionStatus) ? $this->RetentionStatus : null;
    }
    /**
     * Set RetentionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $retentionStatus
     * @return \StructType\NominatedCLIDetails
     */
    public function setRetentionStatus($retentionStatus = null)
    {
        // validation for constraint: string
        if (!is_null($retentionStatus) && !is_string($retentionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retentionStatus)), __LINE__);
        }
        if (is_null($retentionStatus) || (is_array($retentionStatus) && empty($retentionStatus))) {
            unset($this->RetentionStatus);
        } else {
            $this->RetentionStatus = $retentionStatus;
        }
        return $this;
    }
    /**
     * Get ServiceIncompatibility value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceIncompatibility()
    {
        return isset($this->ServiceIncompatibility) ? $this->ServiceIncompatibility : null;
    }
    /**
     * Set ServiceIncompatibility value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceIncompatibility
     * @return \StructType\NominatedCLIDetails
     */
    public function setServiceIncompatibility($serviceIncompatibility = null)
    {
        // validation for constraint: string
        if (!is_null($serviceIncompatibility) && !is_string($serviceIncompatibility)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceIncompatibility)), __LINE__);
        }
        if (is_null($serviceIncompatibility) || (is_array($serviceIncompatibility) && empty($serviceIncompatibility))) {
            unset($this->ServiceIncompatibility);
        } else {
            $this->ServiceIncompatibility = $serviceIncompatibility;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NominatedCLIDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
