<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkProductResiliencyRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NetworkProductResiliencyRequest
 * @subpackage Structs
 */
class NetworkProductResiliencyRequest extends AuthenticateRequestBase
{
    /**
     * The PrimaryAccessCircuit
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\PrimaryAccessIdentifier
     */
    public $PrimaryAccessCircuit;
    /**
     * The RequestDetails
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \StructType\ResiliencyRequest
     */
    public $RequestDetails;
    /**
     * The ResilienceCircuitTypeRequired
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ResilienceCircuitTypeRequired;
    /**
     * The UserConsent
     * @var string
     */
    public $UserConsent;
    /**
     * Constructor method for NetworkProductResiliencyRequest
     * @uses NetworkProductResiliencyRequest::setPrimaryAccessCircuit()
     * @uses NetworkProductResiliencyRequest::setRequestDetails()
     * @uses NetworkProductResiliencyRequest::setResilienceCircuitTypeRequired()
     * @uses NetworkProductResiliencyRequest::setUserConsent()
     * @param \StructType\PrimaryAccessIdentifier $primaryAccessCircuit
     * @param \StructType\ResiliencyRequest $requestDetails
     * @param \ArrayType\ArrayOfstring $resilienceCircuitTypeRequired
     * @param string $userConsent
     */
    public function __construct(\StructType\PrimaryAccessIdentifier $primaryAccessCircuit = null, \StructType\ResiliencyRequest $requestDetails = null, \ArrayType\ArrayOfstring $resilienceCircuitTypeRequired = null, $userConsent = null)
    {
        $this
            ->setPrimaryAccessCircuit($primaryAccessCircuit)
            ->setRequestDetails($requestDetails)
            ->setResilienceCircuitTypeRequired($resilienceCircuitTypeRequired)
            ->setUserConsent($userConsent);
    }
    /**
     * Get PrimaryAccessCircuit value
     * @return \StructType\PrimaryAccessIdentifier|null
     */
    public function getPrimaryAccessCircuit()
    {
        return $this->PrimaryAccessCircuit;
    }
    /**
     * Set PrimaryAccessCircuit value
     * @param \StructType\PrimaryAccessIdentifier $primaryAccessCircuit
     * @return \StructType\NetworkProductResiliencyRequest
     */
    public function setPrimaryAccessCircuit(\StructType\PrimaryAccessIdentifier $primaryAccessCircuit = null)
    {
        $this->PrimaryAccessCircuit = $primaryAccessCircuit;
        return $this;
    }
    /**
     * Get RequestDetails value
     * @return \StructType\ResiliencyRequest|null
     */
    public function getRequestDetails()
    {
        return $this->RequestDetails;
    }
    /**
     * Set RequestDetails value
     * @param \StructType\ResiliencyRequest $requestDetails
     * @return \StructType\NetworkProductResiliencyRequest
     */
    public function setRequestDetails(\StructType\ResiliencyRequest $requestDetails = null)
    {
        $this->RequestDetails = $requestDetails;
        return $this;
    }
    /**
     * Get ResilienceCircuitTypeRequired value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getResilienceCircuitTypeRequired()
    {
        return $this->ResilienceCircuitTypeRequired;
    }
    /**
     * Set ResilienceCircuitTypeRequired value
     * @param \ArrayType\ArrayOfstring $resilienceCircuitTypeRequired
     * @return \StructType\NetworkProductResiliencyRequest
     */
    public function setResilienceCircuitTypeRequired(\ArrayType\ArrayOfstring $resilienceCircuitTypeRequired = null)
    {
        $this->ResilienceCircuitTypeRequired = $resilienceCircuitTypeRequired;
        return $this;
    }
    /**
     * Get UserConsent value
     * @return string|null
     */
    public function getUserConsent()
    {
        return $this->UserConsent;
    }
    /**
     * Set UserConsent value
     * @uses \EnumType\UserConsent::valueIsValid()
     * @uses \EnumType\UserConsent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userConsent
     * @return \StructType\NetworkProductResiliencyRequest
     */
    public function setUserConsent($userConsent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserConsent::valueIsValid($userConsent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userConsent, implode(', ', \EnumType\UserConsent::getValidValues())), __LINE__);
        }
        $this->UserConsent = $userConsent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NetworkProductResiliencyRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
