<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NetworkProductAvailabilityRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NetworkProductAvailabilityRequest
 * @subpackage Structs
 */
class NetworkProductAvailabilityRequest extends AuthenticateRequestBase
{
    /**
     * The AccessCircuit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $AccessCircuit;
    /**
     * The NominatedCLIRequestDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\NominatedCLIRequest
     */
    public $NominatedCLIRequestDetails;
    /**
     * The RequestDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AvailabilityRequest
     */
    public $RequestDetails;
    /**
     * The UserConsent
     * @var string
     */
    public $UserConsent;
    /**
     * Constructor method for NetworkProductAvailabilityRequest
     * @uses NetworkProductAvailabilityRequest::setAccessCircuit()
     * @uses NetworkProductAvailabilityRequest::setNominatedCLIRequestDetails()
     * @uses NetworkProductAvailabilityRequest::setRequestDetails()
     * @uses NetworkProductAvailabilityRequest::setUserConsent()
     * @param \ArrayType\ArrayOfstring $accessCircuit
     * @param \StructType\NominatedCLIRequest $nominatedCLIRequestDetails
     * @param \StructType\AvailabilityRequest $requestDetails
     * @param string $userConsent
     */
    public function __construct(\ArrayType\ArrayOfstring $accessCircuit = null, \StructType\NominatedCLIRequest $nominatedCLIRequestDetails = null, \StructType\AvailabilityRequest $requestDetails = null, $userConsent = null)
    {
        $this
            ->setAccessCircuit($accessCircuit)
            ->setNominatedCLIRequestDetails($nominatedCLIRequestDetails)
            ->setRequestDetails($requestDetails)
            ->setUserConsent($userConsent);
    }
    /**
     * Get AccessCircuit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getAccessCircuit()
    {
        return isset($this->AccessCircuit) ? $this->AccessCircuit : null;
    }
    /**
     * Set AccessCircuit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $accessCircuit
     * @return \StructType\NetworkProductAvailabilityRequest
     */
    public function setAccessCircuit(\ArrayType\ArrayOfstring $accessCircuit = null)
    {
        if (is_null($accessCircuit) || (is_array($accessCircuit) && empty($accessCircuit))) {
            unset($this->AccessCircuit);
        } else {
            $this->AccessCircuit = $accessCircuit;
        }
        return $this;
    }
    /**
     * Get NominatedCLIRequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\NominatedCLIRequest|null
     */
    public function getNominatedCLIRequestDetails()
    {
        return isset($this->NominatedCLIRequestDetails) ? $this->NominatedCLIRequestDetails : null;
    }
    /**
     * Set NominatedCLIRequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\NominatedCLIRequest $nominatedCLIRequestDetails
     * @return \StructType\NetworkProductAvailabilityRequest
     */
    public function setNominatedCLIRequestDetails(\StructType\NominatedCLIRequest $nominatedCLIRequestDetails = null)
    {
        if (is_null($nominatedCLIRequestDetails) || (is_array($nominatedCLIRequestDetails) && empty($nominatedCLIRequestDetails))) {
            unset($this->NominatedCLIRequestDetails);
        } else {
            $this->NominatedCLIRequestDetails = $nominatedCLIRequestDetails;
        }
        return $this;
    }
    /**
     * Get RequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AvailabilityRequest|null
     */
    public function getRequestDetails()
    {
        return isset($this->RequestDetails) ? $this->RequestDetails : null;
    }
    /**
     * Set RequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AvailabilityRequest $requestDetails
     * @return \StructType\NetworkProductAvailabilityRequest
     */
    public function setRequestDetails(\StructType\AvailabilityRequest $requestDetails = null)
    {
        if (is_null($requestDetails) || (is_array($requestDetails) && empty($requestDetails))) {
            unset($this->RequestDetails);
        } else {
            $this->RequestDetails = $requestDetails;
        }
        return $this;
    }
    /**
     * Get UserConsent value
     * @return string|null
     */
    public function getUserConsent()
    {
        return $this->UserConsent;
    }
    /**
     * Set UserConsent value
     * @uses \EnumType\UserConsent::valueIsValid()
     * @uses \EnumType\UserConsent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userConsent
     * @return \StructType\NetworkProductAvailabilityRequest
     */
    public function setUserConsent($userConsent = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\UserConsent::valueIsValid($userConsent)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $userConsent, implode(', ', \EnumType\UserConsent::getValidValues())), __LINE__);
        }
        $this->UserConsent = $userConsent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NetworkProductAvailabilityRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
