<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NGAExchangeInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:NGAExchangeInfo
 * @subpackage Structs
 */
class NGAExchangeInfo extends AbstractStructBase
{
    /**
     * The CSSExchangeDistrictCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CSSExchangeDistrictCode;
    /**
     * The L2SID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $L2SID;
    /**
     * The NGACapacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $NGACapacity;
    /**
     * The NGAReadyForServiceDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DateTimeDetails
     */
    public $NGAReadyForServiceDate;
    /**
     * The NGAState
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NGAState;
    /**
     * The OHPExchangeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OHPExchangeCode;
    /**
     * The OHPExchangeName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OHPExchangeName;
    /**
     * The OHPExchangeRAGCoverage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RAGPercentageCoverage
     */
    public $OHPExchangeRAGCoverage;
    /**
     * The ProductMessages
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNGAProductMessage
     */
    public $ProductMessages;
    /**
     * The ResilienceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ReslilienceInformationResult
     */
    public $ResilienceInformation;
    /**
     * The RolloutDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfNGARolloutDetails
     */
    public $RolloutDetails;
    /**
     * Constructor method for NGAExchangeInfo
     * @uses NGAExchangeInfo::setCSSExchangeDistrictCode()
     * @uses NGAExchangeInfo::setL2SID()
     * @uses NGAExchangeInfo::setNGACapacity()
     * @uses NGAExchangeInfo::setNGAReadyForServiceDate()
     * @uses NGAExchangeInfo::setNGAState()
     * @uses NGAExchangeInfo::setOHPExchangeCode()
     * @uses NGAExchangeInfo::setOHPExchangeName()
     * @uses NGAExchangeInfo::setOHPExchangeRAGCoverage()
     * @uses NGAExchangeInfo::setProductMessages()
     * @uses NGAExchangeInfo::setResilienceInformation()
     * @uses NGAExchangeInfo::setRolloutDetails()
     * @param string $cSSExchangeDistrictCode
     * @param string $l2SID
     * @param string $nGACapacity
     * @param \StructType\DateTimeDetails $nGAReadyForServiceDate
     * @param string $nGAState
     * @param string $oHPExchangeCode
     * @param string $oHPExchangeName
     * @param \StructType\RAGPercentageCoverage $oHPExchangeRAGCoverage
     * @param \ArrayType\ArrayOfNGAProductMessage $productMessages
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @param \ArrayType\ArrayOfNGARolloutDetails $rolloutDetails
     */
    public function __construct($cSSExchangeDistrictCode = null, $l2SID = null, $nGACapacity = null, \StructType\DateTimeDetails $nGAReadyForServiceDate = null, $nGAState = null, $oHPExchangeCode = null, $oHPExchangeName = null, \StructType\RAGPercentageCoverage $oHPExchangeRAGCoverage = null, \ArrayType\ArrayOfNGAProductMessage $productMessages = null, \StructType\ReslilienceInformationResult $resilienceInformation = null, \ArrayType\ArrayOfNGARolloutDetails $rolloutDetails = null)
    {
        $this
            ->setCSSExchangeDistrictCode($cSSExchangeDistrictCode)
            ->setL2SID($l2SID)
            ->setNGACapacity($nGACapacity)
            ->setNGAReadyForServiceDate($nGAReadyForServiceDate)
            ->setNGAState($nGAState)
            ->setOHPExchangeCode($oHPExchangeCode)
            ->setOHPExchangeName($oHPExchangeName)
            ->setOHPExchangeRAGCoverage($oHPExchangeRAGCoverage)
            ->setProductMessages($productMessages)
            ->setResilienceInformation($resilienceInformation)
            ->setRolloutDetails($rolloutDetails);
    }
    /**
     * Get CSSExchangeDistrictCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCSSExchangeDistrictCode()
    {
        return isset($this->CSSExchangeDistrictCode) ? $this->CSSExchangeDistrictCode : null;
    }
    /**
     * Set CSSExchangeDistrictCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cSSExchangeDistrictCode
     * @return \StructType\NGAExchangeInfo
     */
    public function setCSSExchangeDistrictCode($cSSExchangeDistrictCode = null)
    {
        // validation for constraint: string
        if (!is_null($cSSExchangeDistrictCode) && !is_string($cSSExchangeDistrictCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cSSExchangeDistrictCode)), __LINE__);
        }
        if (is_null($cSSExchangeDistrictCode) || (is_array($cSSExchangeDistrictCode) && empty($cSSExchangeDistrictCode))) {
            unset($this->CSSExchangeDistrictCode);
        } else {
            $this->CSSExchangeDistrictCode = $cSSExchangeDistrictCode;
        }
        return $this;
    }
    /**
     * Get L2SID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getL2SID()
    {
        return isset($this->L2SID) ? $this->L2SID : null;
    }
    /**
     * Set L2SID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $l2SID
     * @return \StructType\NGAExchangeInfo
     */
    public function setL2SID($l2SID = null)
    {
        // validation for constraint: string
        if (!is_null($l2SID) && !is_string($l2SID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($l2SID)), __LINE__);
        }
        if (is_null($l2SID) || (is_array($l2SID) && empty($l2SID))) {
            unset($this->L2SID);
        } else {
            $this->L2SID = $l2SID;
        }
        return $this;
    }
    /**
     * Get NGACapacity value
     * @return string|null
     */
    public function getNGACapacity()
    {
        return $this->NGACapacity;
    }
    /**
     * Set NGACapacity value
     * @uses \EnumType\NGACapacityEnum::valueIsValid()
     * @uses \EnumType\NGACapacityEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nGACapacity
     * @return \StructType\NGAExchangeInfo
     */
    public function setNGACapacity($nGACapacity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NGACapacityEnum::valueIsValid($nGACapacity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nGACapacity, implode(', ', \EnumType\NGACapacityEnum::getValidValues())), __LINE__);
        }
        $this->NGACapacity = $nGACapacity;
        return $this;
    }
    /**
     * Get NGAReadyForServiceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DateTimeDetails|null
     */
    public function getNGAReadyForServiceDate()
    {
        return isset($this->NGAReadyForServiceDate) ? $this->NGAReadyForServiceDate : null;
    }
    /**
     * Set NGAReadyForServiceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DateTimeDetails $nGAReadyForServiceDate
     * @return \StructType\NGAExchangeInfo
     */
    public function setNGAReadyForServiceDate(\StructType\DateTimeDetails $nGAReadyForServiceDate = null)
    {
        if (is_null($nGAReadyForServiceDate) || (is_array($nGAReadyForServiceDate) && empty($nGAReadyForServiceDate))) {
            unset($this->NGAReadyForServiceDate);
        } else {
            $this->NGAReadyForServiceDate = $nGAReadyForServiceDate;
        }
        return $this;
    }
    /**
     * Get NGAState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNGAState()
    {
        return isset($this->NGAState) ? $this->NGAState : null;
    }
    /**
     * Set NGAState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nGAState
     * @return \StructType\NGAExchangeInfo
     */
    public function setNGAState($nGAState = null)
    {
        // validation for constraint: string
        if (!is_null($nGAState) && !is_string($nGAState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nGAState)), __LINE__);
        }
        if (is_null($nGAState) || (is_array($nGAState) && empty($nGAState))) {
            unset($this->NGAState);
        } else {
            $this->NGAState = $nGAState;
        }
        return $this;
    }
    /**
     * Get OHPExchangeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOHPExchangeCode()
    {
        return isset($this->OHPExchangeCode) ? $this->OHPExchangeCode : null;
    }
    /**
     * Set OHPExchangeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oHPExchangeCode
     * @return \StructType\NGAExchangeInfo
     */
    public function setOHPExchangeCode($oHPExchangeCode = null)
    {
        // validation for constraint: string
        if (!is_null($oHPExchangeCode) && !is_string($oHPExchangeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oHPExchangeCode)), __LINE__);
        }
        if (is_null($oHPExchangeCode) || (is_array($oHPExchangeCode) && empty($oHPExchangeCode))) {
            unset($this->OHPExchangeCode);
        } else {
            $this->OHPExchangeCode = $oHPExchangeCode;
        }
        return $this;
    }
    /**
     * Get OHPExchangeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOHPExchangeName()
    {
        return isset($this->OHPExchangeName) ? $this->OHPExchangeName : null;
    }
    /**
     * Set OHPExchangeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oHPExchangeName
     * @return \StructType\NGAExchangeInfo
     */
    public function setOHPExchangeName($oHPExchangeName = null)
    {
        // validation for constraint: string
        if (!is_null($oHPExchangeName) && !is_string($oHPExchangeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($oHPExchangeName)), __LINE__);
        }
        if (is_null($oHPExchangeName) || (is_array($oHPExchangeName) && empty($oHPExchangeName))) {
            unset($this->OHPExchangeName);
        } else {
            $this->OHPExchangeName = $oHPExchangeName;
        }
        return $this;
    }
    /**
     * Get OHPExchangeRAGCoverage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RAGPercentageCoverage|null
     */
    public function getOHPExchangeRAGCoverage()
    {
        return isset($this->OHPExchangeRAGCoverage) ? $this->OHPExchangeRAGCoverage : null;
    }
    /**
     * Set OHPExchangeRAGCoverage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\RAGPercentageCoverage $oHPExchangeRAGCoverage
     * @return \StructType\NGAExchangeInfo
     */
    public function setOHPExchangeRAGCoverage(\StructType\RAGPercentageCoverage $oHPExchangeRAGCoverage = null)
    {
        if (is_null($oHPExchangeRAGCoverage) || (is_array($oHPExchangeRAGCoverage) && empty($oHPExchangeRAGCoverage))) {
            unset($this->OHPExchangeRAGCoverage);
        } else {
            $this->OHPExchangeRAGCoverage = $oHPExchangeRAGCoverage;
        }
        return $this;
    }
    /**
     * Get ProductMessages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNGAProductMessage|null
     */
    public function getProductMessages()
    {
        return isset($this->ProductMessages) ? $this->ProductMessages : null;
    }
    /**
     * Set ProductMessages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNGAProductMessage $productMessages
     * @return \StructType\NGAExchangeInfo
     */
    public function setProductMessages(\ArrayType\ArrayOfNGAProductMessage $productMessages = null)
    {
        if (is_null($productMessages) || (is_array($productMessages) && empty($productMessages))) {
            unset($this->ProductMessages);
        } else {
            $this->ProductMessages = $productMessages;
        }
        return $this;
    }
    /**
     * Get ResilienceInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ReslilienceInformationResult|null
     */
    public function getResilienceInformation()
    {
        return isset($this->ResilienceInformation) ? $this->ResilienceInformation : null;
    }
    /**
     * Set ResilienceInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ReslilienceInformationResult $resilienceInformation
     * @return \StructType\NGAExchangeInfo
     */
    public function setResilienceInformation(\StructType\ReslilienceInformationResult $resilienceInformation = null)
    {
        if (is_null($resilienceInformation) || (is_array($resilienceInformation) && empty($resilienceInformation))) {
            unset($this->ResilienceInformation);
        } else {
            $this->ResilienceInformation = $resilienceInformation;
        }
        return $this;
    }
    /**
     * Get RolloutDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfNGARolloutDetails|null
     */
    public function getRolloutDetails()
    {
        return isset($this->RolloutDetails) ? $this->RolloutDetails : null;
    }
    /**
     * Set RolloutDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfNGARolloutDetails $rolloutDetails
     * @return \StructType\NGAExchangeInfo
     */
    public function setRolloutDetails(\ArrayType\ArrayOfNGARolloutDetails $rolloutDetails = null)
    {
        if (is_null($rolloutDetails) || (is_array($rolloutDetails) && empty($rolloutDetails))) {
            unset($this->RolloutDetails);
        } else {
            $this->RolloutDetails = $rolloutDetails;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NGAExchangeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
